<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard | Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav id="sidebar" class="col-md-3 col-lg-2 d-md-block sidebar collapse">
                <div class="position-sticky pt-3">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="?action=dashboard">
                                <i class="fas fa-tachometer-alt me-2"></i>
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=posts">
                                <i class="fas fa-file-alt me-2"></i>
                                Posts Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=pages">
                                <i class="fas fa-file me-2"></i>
                                Pages Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=courses">
                                <i class="fas fa-book me-2"></i>
                                Courses Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=categories">
                                <i class="fas fa-folder me-2"></i>
                                Categories Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=tags">
                                <i class="fas fa-tags me-2"></i>
                                Tags Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=media">
                                <i class="fas fa-images me-2"></i>
                                Media Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=seo">
                                <i class="fas fa-search me-2"></i>
                                SEO Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=mail">
                                <i class="fas fa-envelope me-2"></i>
                                Mail Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=ai">
                                <i class="fas fa-robot me-2"></i>
                                AI Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=notifications">
                                <i class="fas fa-bell me-2"></i>
                                Notifications Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=language">
                                <i class="fas fa-language me-2"></i>
                                Language Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=users">
                                <i class="fas fa-users me-2"></i>
                                Users Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=payment">
                                <i class="fas fa-credit-card me-2"></i>
                                Payment Manager
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=settings">
                                <i class="fas fa-cog me-2"></i>
                                Application Settings
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?action=ads">
                                <i class="fas fa-ad me-2"></i>
                                Ads Manager
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <button class="btn btn-sm btn-outline-secondary" id="sidebarToggle">
                            <i class="fas fa-bars"></i>
                        </button>
                    </div>
                </div>

                <!-- Stats Cards -->
                <div class="row">
                    <div class="col-md-3 mb-4">
                        <div class="card text-white bg-primary">
                            <div class="card-body">
                                <div class="d-flex">
                                    <div>
                                        <h4 class="card-title">1,254</h4>
                                        <p class="card-text">Total Users</p>
                                    </div>
                                    <div class="ms-auto">
                                        <i class="fas fa-users fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-4">
                        <div class="card text-white bg-success">
                            <div class="card-body">
                                <div class="d-flex">
                                    <div>
                                        <h4 class="card-title">342</h4>
                                        <p class="card-text">Active Learners</p>
                                    </div>
                                    <div class="ms-auto">
                                        <i class="fas fa-user-check fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-4">
                        <div class="card text-white bg-warning">
                            <div class="card-body">
                                <div class="d-flex">
                                    <div>
                                        <h4 class="card-title">56</h4>
                                        <p class="card-text">Courses</p>
                                    </div>
                                    <div class="ms-auto">
                                        <i class="fas fa-book fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-4">
                        <div class="card text-white bg-info">
                            <div class="card-body">
                                <div class="d-flex">
                                    <div>
                                        <h4 class="card-title">87%</h4>
                                        <p class="card-text">Completion Rate</p>
                                    </div>
                                    <div class="ms-auto">
                                        <i class="fas fa-chart-line fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h5>Recent User Activity</h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>User</th>
                                                <th>Activity</th>
                                                <th>Time</th>
                                                <th>Level</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>John Doe</td>
                                                <td>Completed Grammar Lesson</td>
                                                <td>2 hours ago</td>
                                                <td><span class="badge bg-primary">B1</span></td>
                                            </tr>
                                            <tr>
                                                <td>Jane Smith</td>
                                                <td>Started Placement Test</td>
                                                <td>4 hours ago</td>
                                                <td><span class="badge bg-secondary">New</span></td>
                                            </tr>
                                            <tr>
                                                <td>Mike Johnson</td>
                                                <td>Advanced to B2 Level</td>
                                                <td>1 day ago</td>
                                                <td><span class="badge bg-success">B2</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5>Level Distribution</h5>
                            </div>
                            <div class="card-body">
                                <canvas id="levelChart" width="100%" height="200"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="../assets/js/admin.js"></script>
</body>
</html>