<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    die('Please login to admin first.');
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../app/config/database.php';
$database = new Database();
$db = $database->getConnection();

if (!$db) {
    die('Database connection failed');
}

echo "<!DOCTYPE html>
<html>
<head>
    <title>Fix Database Schema</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css' rel='stylesheet'>
</head>
<body>
    <div class='container mt-5'>
        <h2>Fix Database Schema Issues</h2>
        <div class='card'>
            <div class='card-body'>";

// Fix learning_content table
$fixes = [
    // Add missing columns to learning_content
    "ALTER TABLE learning_content 
     ADD COLUMN IF NOT EXISTS description TEXT AFTER title,
     ADD COLUMN IF NOT EXISTS content TEXT AFTER description,
     ADD COLUMN IF NOT EXISTS duration_minutes INT DEFAULT 15 AFTER skill_type,
     ADD COLUMN IF NOT EXISTS order_index INT DEFAULT 0 AFTER duration_minutes,
     ADD COLUMN IF NOT EXISTS is_active BOOLEAN DEFAULT TRUE AFTER order_index",
    
    // Add missing columns to users table
    "ALTER TABLE users 
     ADD COLUMN IF NOT EXISTS username VARCHAR(100) UNIQUE AFTER last_name,
     ADD COLUMN IF NOT EXISTS profile_image VARCHAR(500) AFTER username,
     ADD COLUMN IF NOT EXISTS bio TEXT AFTER profile_image,
     ADD COLUMN IF NOT EXISTS daily_goal INT DEFAULT 30 AFTER learning_path,
     ADD COLUMN IF NOT EXISTS learning_style ENUM('visual', 'auditory', 'kinesthetic', 'mixed') DEFAULT 'mixed' AFTER daily_goal,
     ADD COLUMN IF NOT EXISTS streak_days INT DEFAULT 0 AFTER learning_style,
     ADD COLUMN IF NOT EXISTS total_time_spent INT DEFAULT 0 AFTER streak_days,
     ADD COLUMN IF NOT EXISTS last_active DATE AFTER total_time_spent",
    
    // Create notifications table if missing
    "CREATE TABLE IF NOT EXISTS notifications (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NULL,
        type ENUM('info', 'alert', 'achievement', 'reminder') DEFAULT 'info',
        title VARCHAR(255) NOT NULL,
        message TEXT NOT NULL,
        is_read BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )",
    
    // Create badges table if missing
    "CREATE TABLE IF NOT EXISTS badges (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) NOT NULL,
        description TEXT,
        icon VARCHAR(50) DEFAULT 'trophy',
        color VARCHAR(20) DEFAULT 'primary',
        criteria TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )",
    
    // Create user_badges table if missing
    "CREATE TABLE IF NOT EXISTS user_badges (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        badge_id INT NOT NULL,
        earned_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        UNIQUE KEY unique_user_badge (user_id, badge_id)
    )",
    
    // Create tasks table if missing
    "CREATE TABLE IF NOT EXISTS tasks (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        title VARCHAR(255) NOT NULL,
        description TEXT,
        due_date DATE,
        completed BOOLEAN DEFAULT FALSE,
        priority ENUM('low', 'medium', 'high') DEFAULT 'medium',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )",
    
    // Create user_progress table if missing
    "CREATE TABLE IF NOT EXISTS user_progress (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        content_id INT NOT NULL,
        completed BOOLEAN DEFAULT FALSE,
        score DECIMAL(5,2),
        time_spent INT DEFAULT 0,
        started_at TIMESTAMP NULL,
        completed_at TIMESTAMP NULL,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        UNIQUE KEY unique_user_content (user_id, content_id)
    )"
];

foreach ($fixes as $fix) {
    try {
        $db->exec($fix);
        echo "<div class='alert alert-success'>✓ Executed: " . substr($fix, 0, 80) . "...</div>";
    } catch (Exception $e) {
        echo "<div class='alert alert-warning'>⚠ " . $e->getMessage() . "</div>";
    }
}

// Insert sample data
try {
    // Insert sample learning content with description
    $levels = ['A1', 'A2', 'B1', 'B2', 'C1', 'C2'];
    $skills = ['reading', 'writing', 'speaking', 'grammar', 'vocabulary'];
    
    foreach ($levels as $level) {
        foreach ($skills as $skill) {
            $title = "$level " . ucfirst($skill) . " Lesson";
            $description = "Comprehensive lesson for $level level $skill practice. This lesson will help you improve your $skill skills through interactive exercises and examples.";
            
            $check = $db->query("SELECT COUNT(*) as count FROM learning_content WHERE title = '$title'")->fetch();
            if ($check['count'] == 0) {
                $db->exec("INSERT INTO learning_content (title, description, level, skill_type) VALUES 
                          ('$title', '$description', '$level', '$skill')");
            } else {
                // Update existing record with description
                $db->exec("UPDATE learning_content SET description = '$description' WHERE title = '$title'");
            }
        }
    }
    echo "<div class='alert alert-info'>✓ Learning content updated with descriptions</div>";
    
    // Insert sample badges
    $badges = [
        ['Fast Learner', 'Complete 5 lessons in one day', 'bolt', 'warning'],
        ['Grammar Guru', 'Achieve 100% in grammar exercises', 'language', 'success'],
        ['Vocabulary Master', 'Learn 100 new words', 'font', 'info']
    ];
    
    foreach ($badges as $badge) {
        $check = $db->query("SELECT COUNT(*) as count FROM badges WHERE name = '{$badge[0]}'")->fetch();
        if ($check['count'] == 0) {
            $db->exec("INSERT INTO badges (name, description, icon, color) VALUES 
                      ('{$badge[0]}', '{$badge[1]}', '{$badge[2]}', '{$badge[3]}')");
        }
    }
    echo "<div class='alert alert-info'>✓ Sample badges added</div>";
    
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>✗ Error inserting sample data: " . $e->getMessage() . "</div>";
}

echo "<div class='alert alert-success mt-3'><strong>Database fixes applied!</strong></div>";
echo "<a href='/dashboard' class='btn btn-primary'>Test Dashboard</a>";
echo "<a href='/login.php' class='btn btn-secondary ms-2'>Test Login</a>";
echo "</div></div></div></body></html>";
?>