<?php
session_start();

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// Define base path
define('BASE_PATH', dirname(__DIR__));

// Include database configuration
require_once BASE_PATH . '/app/config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
} catch (Exception $e) {
    $db = null;
}

// Get action from URL
$action = $_GET['action'] ?? 'dashboard';

// Process form submissions BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $process_file = "views/process_{$action}.php";
    if (file_exists($process_file)) {
        require $process_file;
        exit; // Stop execution after processing
    }
}

// Process GET actions that might redirect (like delete, edit operations)
$allowed_actions = [
    'posts', 'pages', 'categories', 'media', 'users', 'courses', 
    'ads', 'tags', 'notifications', 'language', 'payment', 'ai'
];
if (isset($_GET['delete']) && in_array($action, $allowed_actions)) {
    $process_file = "views/process_{$action}.php";
    if (file_exists($process_file)) {
        require $process_file;
        exit;
    }
}

// Process other GET actions that modify data
if (isset($_GET['toggle']) || isset($_GET['bulk_action']) || isset($_GET['send']) || 
    isset($_GET['set_default']) || isset($_GET['set_default'])) {
    $process_file = "views/process_{$action}.php";
    if (file_exists($process_file)) {
        require $process_file;
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            position: fixed;
            top: 0;
            left: 0;
            width: 250px;
            z-index: 1000;
            transform: translateX(-100%);
            transition: transform 0.3s ease;
        }
        .sidebar.show {
            transform: translateX(0);
        }
        .sidebar .nav-link {
            color: #adb5bd;
            padding: 12px 20px;
            margin: 2px 0;
            border-radius: 0;
            transition: all 0.3s;
        }
        .sidebar .nav-link:hover {
            color: #fff;
            background: #495057;
        }
        .sidebar .nav-link.active {
            color: #fff;
            background: #007bff;
        }
        .sidebar .nav-link i {
            width: 20px;
            text-align: center;
            margin-right: 10px;
        }
        .main-content {
            margin-left: 0;
            transition: margin-left 0.3s ease;
        }
        .main-content.expanded {
            margin-left: 250px;
        }
        .navbar-brand {
            font-weight: 600;
        }
        .stat-card {
            border-radius: 10px;
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-2px);
        }
        .sidebar-toggle {
            display: block;
        }
        @media (min-width: 992px) {
            .sidebar {
                transform: translateX(0);
                position: static;
            }
            .main-content {
                margin-left: 250px;
            }
            .sidebar-toggle {
                display: none;
            }
        }
    </style>
</head>
<body>
    <!-- Top Navigation -->
    <nav class="navbar navbar-dark bg-dark fixed-top">
        <div class="container-fluid">
            <button class="btn btn-dark sidebar-toggle" type="button" onclick="toggleSidebar()">
                <i class="fas fa-bars"></i>
            </button>
            <span class="navbar-brand">Simturax Admin</span>
            <div class="navbar-nav ms-auto d-flex flex-row align-items-center">
                <span class="nav-link text-light me-3">
                    <i class="fas fa-user-circle me-1"></i>
                    <?php echo $_SESSION['admin_username'] ?? 'Admin'; ?>
                </span>
                <div class="btn-group">
                    <a href="quick_setup.php" class="btn btn-warning btn-sm me-2">
                        <i class="fas fa-database me-1"></i>Setup DB
                    </a>
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="fas fa-sign-out-alt me-1"></i>Logout
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header p-3 border-bottom border-secondary">
            <h5 class="text-white mb-0">
                <i class="fas fa-cogs me-2"></i>
                Admin Menu
            </h5>
        </div>
        <nav class="nav flex-column mt-3">
            <a class="nav-link <?php echo $action === 'dashboard' ? 'active' : ''; ?>" href="?action=dashboard">
                <i class="fas fa-tachometer-alt"></i>Dashboard
            </a>
            
            <div class="px-3 mt-3 text-uppercase small text-muted">Content Management</div>
            <a class="nav-link <?php echo $action === 'posts' ? 'active' : ''; ?>" href="?action=posts">
                <i class="fas fa-file-alt"></i>Posts Manager
            </a>
            <a class="nav-link <?php echo $action === 'pages' ? 'active' : ''; ?>" href="?action=pages">
                <i class="fas fa-file"></i>Pages Manager
            </a>
            <a class="nav-link <?php echo $action === 'courses' ? 'active' : ''; ?>" href="?action=courses">
                <i class="fas fa-book"></i>Courses Manager
            </a>
            <a class="nav-link <?php echo $action === 'categories' ? 'active' : ''; ?>" href="?action=categories">
                <i class="fas fa-folder"></i>Categories Manager
            </a>
            <a class="nav-link <?php echo $action === 'tags' ? 'active' : ''; ?>" href="?action=tags">
                <i class="fas fa-tags"></i>Tags Manager
            </a>
            <a class="nav-link <?php echo $action === 'media' ? 'active' : ''; ?>" href="?action=media">
                <i class="fas fa-images"></i>Media Manager
            </a>
            
            <div class="px-3 mt-3 text-uppercase small text-muted">User Management</div>
            <a class="nav-link <?php echo $action === 'users' ? 'active' : ''; ?>" href="?action=users">
                <i class="fas fa-users"></i>Users Manager
            </a>
            <a class="nav-link <?php echo $action === 'payment' ? 'active' : ''; ?>" href="?action=payment">
                <i class="fas fa-credit-card"></i>Payment Manager
            </a>
            
            <div class="px-3 mt-3 text-uppercase small text-muted">System Tools</div>
            <a class="nav-link <?php echo $action === 'ai' ? 'active' : ''; ?>" href="?action=ai">
                <i class="fas fa-robot"></i>AI Manager
            </a>
            <a class="nav-link <?php echo $action === 'notifications' ? 'active' : ''; ?>" href="?action=notifications">
                <i class="fas fa-bell"></i>Notifications Manager
            </a>
            <a class="nav-link <?php echo $action === 'language' ? 'active' : ''; ?>" href="?action=language">
                <i class="fas fa-language"></i>Language Manager
            </a>
            <a class="nav-link <?php echo $action === 'ads' ? 'active' : ''; ?>" href="?action=ads">
                <i class="fas fa-ad"></i>Ads Manager
            </a>
            <a class="nav-link <?php echo $action === 'settings' ? 'active' : ''; ?>" href="?action=settings">
                <i class="fas fa-cog"></i>Settings
            </a>
        </nav>
        
        <div class="sidebar-footer p-3 border-top border-secondary mt-auto">
            <small class="text-muted">Simturax v1.0</small>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <div class="container-fluid mt-5 pt-3">
            <?php if (!$db): ?>
            <div class="alert alert-warning">
                <strong>Database Connection Issue:</strong> Some features may not work properly. 
                <a href="quick_setup.php" class="alert-link">Run database setup</a> to fix this.
            </div>
            <?php endif; ?>

            <?php
            // Display success/error messages
            if ($_GET['success'] ?? '') {
                echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                        Operation completed successfully!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                      </div>';
            }
            
            if ($_GET['error'] ?? '') {
                echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                        ' . htmlspecialchars($_GET['error']) . '
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                      </div>';
            }

            // Display content based on action
            $view_file = "views/{$action}.php";
            if (file_exists($view_file)) {
                include $view_file;
            } else {
                echo "<div class='alert alert-warning'>Manager for '{$action}' is coming soon.</div>";
                echo "<div class='card'>
                        <div class='card-body text-center py-5'>
                            <i class='fas fa-cogs fa-3x text-muted mb-3'></i>
                            <h4>Manager Under Development</h4>
                            <p class='text-muted'>The {$action} manager is currently being developed and will be available soon.</p>
                            <a href='?action=dashboard' class='btn btn-primary'>Return to Dashboard</a>
                        </div>
                      </div>";
            }
            ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            sidebar.classList.toggle('show');
            mainContent.classList.toggle('expanded');
        }

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const sidebarToggle = document.querySelector('.sidebar-toggle');
            const isClickInsideSidebar = sidebar.contains(event.target);
            const isClickOnToggle = sidebarToggle.contains(event.target);
            
            if (window.innerWidth < 992 && !isClickInsideSidebar && !isClickOnToggle && sidebar.classList.contains('show')) {
                toggleSidebar();
            }
        });

        // Handle window resize
        window.addEventListener('resize', function() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            
            if (window.innerWidth >= 992) {
                sidebar.classList.remove('show');
                mainContent.classList.remove('expanded');
            }
        });

        // Auto-hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }, 5000);
            });
        });
    </script>
</body>
</html>