<?php
// Display AI manager - no form processing here
if (!isset($db) || !$db) {
    echo '<div class="alert alert-danger">Database connection not available</div>';
    return;
}

try {
    // Fetch AI settings
    $query = "SELECT * FROM ai_settings";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $settings = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Convert to key-value pairs
    $settings_array = [];
    foreach ($settings as $setting) {
        $settings_array[$setting['setting_key']] = $setting['setting_value'];
    }

    // Default AI settings
    $default_settings = [
        'ai_enabled' => '1',
        'openai_api_key' => '',
        'ai_model' => 'gpt-3.5-turbo',
        'max_tokens' => '1000',
        'temperature' => '0.7',
        'auto_generate_exercises' => '1',
        'auto_suggest_content' => '1'
    ];

    // Merge with existing settings
    $current_settings = array_merge($default_settings, $settings_array);
} catch (Exception $e) {
    echo '<div class="alert alert-warning">AI settings not configured yet</div>';
    $current_settings = $default_settings;
}

// Content types for generation
$contentTypes = [
    'reading_passage' => 'Reading Passage',
    'writing_prompt' => 'Writing Prompt',
    'conversation' => 'Conversation Practice',
    'grammar_exercise' => 'Grammar Exercise',
    'vocabulary_quiz' => 'Vocabulary Quiz',
    'listening_exercise' => 'Listening Exercise'
];

// Skill types
$skillTypes = [
    'reading' => 'Reading',
    'writing' => 'Writing',
    'speaking' => 'Speaking',
    'grammar' => 'Grammar',
    'vocabulary' => 'Vocabulary',
    'listening' => 'Listening'
];

// Levels
$levels = [
    'A1' => 'Beginner (A1)',
    'A2' => 'Elementary (A2)',
    'B1' => 'Intermediate (B1)',
    'B2' => 'Upper Intermediate (B2)',
    'C1' => 'Advanced (C1)',
    'C2' => 'Proficient (C2)'
];
?>
<div class="row">
    <div class="col-12">
        <h2 class="mb-4">AI Manager</h2>
    </div>
</div>

<?php if ($_GET['generated'] ?? ''): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <h5>AI Content Generated!</h5>
    <p><strong>Topic:</strong> <?php echo htmlspecialchars($_SESSION['ai_content_topic'] ?? ''); ?></p>
    <p><strong>Type:</strong> <?php echo $contentTypes[$_SESSION['ai_content_type'] ?? ''] ?? 'Unknown'; ?></p>
    <hr>
    <p><?php echo nl2br(htmlspecialchars($_SESSION['ai_generated_content'] ?? '')); ?></p>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="row">
    <div class="col-md-6">
        <!-- AI Content Generator -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">AI Content Generator</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="?action=ai">
                    <input type="hidden" name="action" value="generate_content">
                    
                    <div class="mb-3">
                        <label for="content_type" class="form-label">Content Type *</label>
                        <select class="form-select" id="content_type" name="content_type" required>
                            <option value="">Select content type...</option>
                            <?php foreach ($contentTypes as $key => $name): ?>
                            <option value="<?php echo $key; ?>"><?php echo $name; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="topic" class="form-label">Topic *</label>
                        <input type="text" class="form-control" id="topic" name="topic" 
                               placeholder="e.g., Daily routines, Environmental issues, Travel experiences" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="level" class="form-label">English Level</label>
                                <select class="form-select" id="level" name="level">
                                    <?php foreach ($levels as $key => $name): ?>
                                    <option value="<?php echo $key; ?>"><?php echo $name; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="skill_type" class="form-label">Skill Type</label>
                                <select class="form-select" id="skill_type" name="skill_type">
                                    <?php foreach ($skillTypes as $key => $name): ?>
                                    <option value="<?php echo $key; ?>"><?php echo $name; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-robot me-2"></i>Generate Content
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <!-- AI Analytics -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">AI Analytics</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6 mb-3">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-primary">24</h3>
                                <small>Content Generated</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-success">87%</h3>
                                <small>Success Rate</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-info">156</h3>
                                <small>API Calls</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-warning">2.3s</h3>
                                <small>Avg. Response Time</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button class="btn btn-outline-primary" disabled>
                        <i class="fas fa-sync-alt me-2"></i>Generate Course Recommendations
                    </button>
                    <button class="btn btn-outline-success" disabled>
                        <i class="fas fa-chart-line me-2"></i>Analyze Student Progress
                    </button>
                    <button class="btn btn-outline-info" disabled>
                        <i class="fas fa-comments me-2"></i>Create Conversation Practice
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- AI Settings -->
<div class="card mt-4">
    <div class="card-header">
        <h5 class="mb-0">AI Settings</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="?action=ai">
            <input type="hidden" name="action" value="update_ai_settings">
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">AI Features</label>
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" id="ai_enabled" 
                                   name="settings[ai_enabled]" value="1" 
                                   <?php echo $current_settings['ai_enabled'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="ai_enabled">Enable AI Features</label>
                        </div>
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" id="auto_generate_exercises" 
                                   name="settings[auto_generate_exercises]" value="1" 
                                   <?php echo $current_settings['auto_generate_exercises'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="auto_generate_exercises">Auto-generate Exercises</label>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="auto_suggest_content" 
                                   name="settings[auto_suggest_content]" value="1" 
                                   <?php echo $current_settings['auto_suggest_content'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="auto_suggest_content">Auto-suggest Content</label>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="openai_api_key" class="form-label">OpenAI API Key</label>
                        <input type="password" class="form-control" id="openai_api_key" 
                               name="settings[openai_api_key]" 
                               value="<?php echo htmlspecialchars($current_settings['openai_api_key']); ?>"
                               placeholder="sk-...">
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="ai_model" class="form-label">AI Model</label>
                        <select class="form-select" id="ai_model" name="settings[ai_model]">
                            <option value="gpt-3.5-turbo" <?php echo ($current_settings['ai_model'] ?? '') == 'gpt-3.5-turbo' ? 'selected' : ''; ?>>GPT-3.5 Turbo</option>
                            <option value="gpt-4" <?php echo ($current_settings['ai_model'] ?? '') == 'gpt-4' ? 'selected' : ''; ?>>GPT-4</option>
                            <option value="gpt-4-turbo" <?php echo ($current_settings['ai_model'] ?? '') == 'gpt-4-turbo' ? 'selected' : ''; ?>>GPT-4 Turbo</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="max_tokens" class="form-label">Max Tokens</label>
                        <input type="number" class="form-control" id="max_tokens" 
                               name="settings[max_tokens]" 
                               value="<?php echo htmlspecialchars($current_settings['max_tokens']); ?>"
                               min="100" max="4000">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="temperature" class="form-label">Temperature</label>
                        <input type="number" class="form-control" id="temperature" 
                               name="settings[temperature]" 
                               value="<?php echo htmlspecialchars($current_settings['temperature']); ?>"
                               min="0" max="1" step="0.1">
                        <div class="form-text">0 = deterministic, 1 = creative</div>
                    </div>
                </div>
            </div>
            
            <div class="text-center">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Save AI Settings
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle checkbox values for form submission
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    checkboxes.forEach(checkbox => {
        // Set initial value
        checkbox.value = checkbox.checked ? '1' : '0';
        
        checkbox.addEventListener('change', function() {
            this.value = this.checked ? '1' : '0';
        });
    });
});
</script>