<?php
// Display categories - no form processing here
if (!isset($db) || !$db) {
    echo '<div class="alert alert-danger">Database connection not available</div>';
    return;
}

try {
    // Fetch categories (read-only operations)
    $query = "SELECT * FROM categories ORDER BY type, name";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get category for editing (read-only)
    $edit_category = null;
    if ($_GET['edit'] ?? '') {
        $query = "SELECT * FROM categories WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$_GET['edit']]);
        $edit_category = $stmt->fetch(PDO::FETCH_ASSOC);
    }
} catch (Exception $e) {
    echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    $categories = [];
}
?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Categories Manager</h2>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#categoryModal">
                <i class="fas fa-plus me-2"></i>Add New Category
            </button>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">All Categories</h5>
    </div>
    <div class="card-body">
        <?php if (empty($categories)): ?>
        <div class="text-center py-4">
            <i class="fas fa-folder fa-3x text-muted mb-3"></i>
            <p class="text-muted">No categories found. Create your first category!</p>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#categoryModal">
                Create First Category
            </button>
        </div>
        <?php else: ?>
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($categories as $category): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($category['id']); ?></td>
                        <td><strong><?php echo htmlspecialchars($category['name']); ?></strong></td>
                        <td><?php echo htmlspecialchars($category['description'] ?? '-'); ?></td>
                        <td>
                            <span class="badge bg-info"><?php echo ucfirst($category['type']); ?></span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo $category['status'] == 'active' ? 'success' : 'secondary'; ?>">
                                <?php echo ucfirst($category['status']); ?>
                            </span>
                        </td>
                        <td><?php echo date('M j, Y', strtotime($category['created_at'])); ?></td>
                        <td>
                            <a href="?action=categories&edit=<?php echo $category['id']; ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="?action=categories&delete=<?php echo $category['id']; ?>" class="btn btn-sm btn-outline-danger" 
                               onclick="return confirm('Are you sure you want to delete this category?')">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Add/Edit Category Modal -->
<div class="modal fade" id="categoryModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $edit_category ? 'Edit Category' : 'Add New Category'; ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="?action=categories">
                <div class="modal-body">
                    <input type="hidden" name="action" value="<?php echo $edit_category ? 'update_category' : 'create_category'; ?>">
                    <?php if ($edit_category): ?>
                    <input type="hidden" name="id" value="<?php echo htmlspecialchars($edit_category['id']); ?>">
                    <?php endif; ?>
                    
                    <div class="mb-3">
                        <label for="name" class="form-label">Category Name *</label>
                        <input type="text" class="form-control" id="name" name="name" 
                               value="<?php echo htmlspecialchars($edit_category['name'] ?? ''); ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="description" 
                                  rows="3"><?php echo htmlspecialchars($edit_category['description'] ?? ''); ?></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="type" class="form-label">Type *</label>
                                <select class="form-select" id="type" name="type" required>
                                    <option value="post" <?php echo ($edit_category['type'] ?? '') == 'post' ? 'selected' : ''; ?>>Post</option>
                                    <option value="course" <?php echo ($edit_category['type'] ?? '') == 'course' ? 'selected' : ''; ?>>Course</option>
                                    <option value="general" <?php echo ($edit_category['type'] ?? '') == 'general' ? 'selected' : ''; ?>>General</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select class="form-select" id="status" name="status" required>
                                    <option value="active" <?php echo ($edit_category['status'] ?? '') == 'active' ? 'selected' : ''; ?>>Active</option>
                                    <option value="inactive" <?php echo ($edit_category['status'] ?? '') == 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary"><?php echo $edit_category ? 'Update Category' : 'Create Category'; ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php if ($_GET['edit'] ?? ''): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var categoryModal = new bootstrap.Modal(document.getElementById('categoryModal'));
    categoryModal.show();
});
</script>
<?php endif; ?>