<?php
// Display pages - no form processing here
if (!isset($db) || !$db) {
    echo '<div class="alert alert-danger">Database connection not available</div>';
    return;
}

try {
    // Fetch pages (read-only operations)
    $query = "SELECT * FROM pages ORDER BY created_at DESC";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $pages = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get page for editing (read-only)
    $edit_page = null;
    if ($_GET['edit'] ?? '') {
        $query = "SELECT * FROM pages WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$_GET['edit']]);
        $edit_page = $stmt->fetch(PDO::FETCH_ASSOC);
    }
} catch (Exception $e) {
    echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    $pages = [];
}
?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Pages Manager</h2>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#pageModal">
                <i class="fas fa-plus me-2"></i>Add New Page
            </button>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">All Pages</h5>
    </div>
    <div class="card-body">
        <?php if (empty($pages)): ?>
        <div class="text-center py-4">
            <i class="fas fa-file fa-3x text-muted mb-3"></i>
            <p class="text-muted">No pages found. Create your first page!</p>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#pageModal">
                Create First Page
            </button>
        </div>
        <?php else: ?>
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Slug</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pages as $page): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($page['id']); ?></td>
                        <td>
                            <strong><?php echo htmlspecialchars($page['title']); ?></strong>
                            <?php if ($page['status'] == 'draft'): ?>
                                <span class="badge bg-warning ms-2">Draft</span>
                            <?php endif; ?>
                        </td>
                        <td><code>/<?php echo htmlspecialchars($page['slug']); ?></code></td>
                        <td>
                            <span class="badge bg-<?php echo $page['status'] == 'published' ? 'success' : 'warning'; ?>">
                                <?php echo ucfirst($page['status']); ?>
                            </span>
                        </td>
                        <td><?php echo date('M j, Y', strtotime($page['created_at'])); ?></td>
                        <td>
                            <a href="?action=pages&edit=<?php echo $page['id']; ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="?action=pages&delete=<?php echo $page['id']; ?>" class="btn btn-sm btn-outline-danger" 
                               onclick="return confirm('Are you sure you want to delete this page?')">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Add/Edit Page Modal -->
<div class="modal fade" id="pageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $edit_page ? 'Edit Page' : 'Add New Page'; ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="?action=pages">
                <div class="modal-body">
                    <input type="hidden" name="action" value="<?php echo $edit_page ? 'update_page' : 'create_page'; ?>">
                    <?php if ($edit_page): ?>
                    <input type="hidden" name="id" value="<?php echo htmlspecialchars($edit_page['id']); ?>">
                    <?php endif; ?>
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Page Title *</label>
                        <input type="text" class="form-control" id="title" name="title" 
                               value="<?php echo htmlspecialchars($edit_page['title'] ?? ''); ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="slug" class="form-label">Slug *</label>
                        <input type="text" class="form-control" id="slug" name="slug" 
                               value="<?php echo htmlspecialchars($edit_page['slug'] ?? ''); ?>" required>
                        <div class="form-text">URL-friendly version (e.g., about-us)</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="status" class="form-label">Status *</label>
                        <select class="form-select" id="status" name="status" required>
                            <option value="draft" <?php echo ($edit_page['status'] ?? '') == 'draft' ? 'selected' : ''; ?>>Draft</option>
                            <option value="published" <?php echo ($edit_page['status'] ?? '') == 'published' ? 'selected' : ''; ?>>Published</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="content" class="form-label">Content *</label>
                        <textarea class="form-control" id="content" name="content" rows="10" 
                                  required><?php echo htmlspecialchars($edit_page['content'] ?? ''); ?></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="meta_title" class="form-label">Meta Title</label>
                                <input type="text" class="form-control" id="meta_title" name="meta_title" 
                                       value="<?php echo htmlspecialchars($edit_page['meta_title'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="meta_description" class="form-label">Meta Description</label>
                                <textarea class="form-control" id="meta_description" name="meta_description" 
                                          rows="3"><?php echo htmlspecialchars($edit_page['meta_description'] ?? ''); ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary"><?php echo $edit_page ? 'Update Page' : 'Create Page'; ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Auto-generate slug from title
document.addEventListener('DOMContentLoaded', function() {
    const titleInput = document.getElementById('title');
    const slugInput = document.getElementById('slug');
    
    if (titleInput && slugInput) {
        titleInput.addEventListener('blur', function() {
            if (!slugInput.value) {
                const slug = this.value.toLowerCase()
                    .replace(/[^a-z0-9]+/g, '-')
                    .replace(/(^-|-$)+/g, '');
                slugInput.value = slug;
            }
        });
    }
});
</script>

<?php if ($_GET['edit'] ?? ''): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var pageModal = new bootstrap.Modal(document.getElementById('pageModal'));
    pageModal.show();
});
</script>
<?php endif; ?>