<?php
// Display payment manager - no form processing here
if (!isset($db) || !$db) {
    echo '<div class="alert alert-danger">Database connection not available</div>';
    return;
}

// Payment status colors
$statusColors = [
    'completed' => 'success',
    'pending' => 'warning',
    'failed' => 'danger',
    'refunded' => 'info',
    'cancelled' => 'secondary'
];

// Sample payment data (in real system, this would come from database)
$payments = [
    [
        'id' => '1',
        'user_email' => 'student1@example.com',
        'amount' => '29.99',
        'currency' => 'USD',
        'plan_name' => 'Premium Monthly',
        'status' => 'completed',
        'created_at' => '2024-01-15 10:30:00'
    ],
    [
        'id' => '2',
        'user_email' => 'student2@example.com',
        'amount' => '99.99',
        'currency' => 'USD',
        'plan_name' => 'Premium Annual',
        'status' => 'pending',
        'created_at' => '2024-01-16 14:20:00'
    ],
    [
        'id' => '3',
        'user_email' => 'student3@example.com',
        'amount' => '29.99',
        'currency' => 'USD',
        'plan_name' => 'Premium Monthly',
        'status' => 'failed',
        'created_at' => '2024-01-17 09:15:00'
    ]
];

// Subscription plans
$plans = [
    [
        'id' => '1',
        'name' => 'Basic Monthly',
        'price' => '9.99',
        'duration_days' => '30',
        'features' => 'Basic access, Limited courses',
        'status' => 'active'
    ],
    [
        'id' => '2',
        'name' => 'Premium Monthly',
        'price' => '29.99',
        'duration_days' => '30',
        'features' => 'Full access, All courses, Progress tracking',
        'status' => 'active'
    ],
    [
        'id' => '3',
        'name' => 'Premium Annual',
        'price' => '299.99',
        'duration_days' => '365',
        'features' => 'Full access, All courses, Progress tracking, Priority support',
        'status' => 'active'
    ]
];
?>
<div class="row">
    <div class="col-12">
        <h2 class="mb-4">Payment Manager</h2>
    </div>
</div>

<!-- Payment Statistics -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex">
                    <div>
                        <h4 class="card-title">$1,259.75</h4>
                        <p class="card-text">Total Revenue</p>
                    </div>
                    <div class="ms-auto">
                        <i class="fas fa-dollar-sign fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex">
                    <div>
                        <h4 class="card-title">42</h4>
                        <p class="card-text">Successful Payments</p>
                    </div>
                    <div class="ms-auto">
                        <i class="fas fa-check-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex">
                    <div>
                        <h4 class="card-title">3</h4>
                        <p class="card-text">Pending Payments</p>
                    </div>
                    <div class="ms-auto">
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <div class="d-flex">
                    <div>
                        <h4 class="card-title">5</h4>
                        <p class="card-text">Failed Payments</p>
                    </div>
                    <div class="ms-auto">
                        <i class="fas fa-times-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <!-- Recent Payments -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Recent Payments</h5>
                <button class="btn btn-sm btn-outline-primary" disabled>
                    <i class="fas fa-download me-1"></i>Export
                </button>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>User</th>
                                <th>Amount</th>
                                <th>Plan</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($payments as $payment): ?>
                            <tr>
                                <td>#<?php echo htmlspecialchars($payment['id']); ?></td>
                                <td><?php echo htmlspecialchars($payment['user_email']); ?></td>
                                <td>
                                    <strong>$<?php echo htmlspecialchars($payment['amount']); ?></strong>
                                    <small class="text-muted"><?php echo $payment['currency']; ?></small>
                                </td>
                                <td><?php echo htmlspecialchars($payment['plan_name']); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $statusColors[$payment['status']] ?? 'secondary'; ?>">
                                        <?php echo ucfirst($payment['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('M j, Y', strtotime($payment['created_at'])); ?></td>
                                <td>
                                    <?php if ($payment['status'] == 'pending'): ?>
                                    <button class="btn btn-sm btn-success" data-bs-toggle="modal" 
                                            data-bs-target="#approveModal" data-payment-id="<?php echo $payment['id']; ?>">
                                        <i class="fas fa-check"></i>
                                    </button>
                                    <?php endif; ?>
                                    
                                    <?php if ($payment['status'] == 'completed'): ?>
                                    <button class="btn btn-sm btn-warning" data-bs-toggle="modal" 
                                            data-bs-target="#refundModal" data-payment-id="<?php echo $payment['id']; ?>">
                                        <i class="fas fa-undo"></i>
                                    </button>
                                    <?php endif; ?>
                                    
                                    <button class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <!-- Subscription Plans -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Subscription Plans</h5>
                <button class="btn btn-sm btn-primary" disabled>
                    <i class="fas fa-plus me-1"></i>New Plan
                </button>
            </div>
            <div class="card-body">
                <?php foreach ($plans as $plan): ?>
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0"><?php echo htmlspecialchars($plan['name']); ?></h6>
                            <span class="badge bg-<?php echo $plan['status'] == 'active' ? 'success' : 'secondary'; ?>">
                                <?php echo ucfirst($plan['status']); ?>
                            </span>
                        </div>
                        <p class="mb-2"><strong>$<?php echo htmlspecialchars($plan['price']); ?></strong> 
                           / <?php echo $plan['duration_days'] == '30' ? 'month' : 'year'; ?></p>
                        <p class="small text-muted mb-2"><?php echo htmlspecialchars($plan['features']); ?></p>
                        <div class="btn-group w-100">
                            <button class="btn btn-sm btn-outline-primary" disabled>Edit</button>
                            <button class="btn btn-sm btn-outline-<?php echo $plan['status'] == 'active' ? 'warning' : 'success'; ?>" disabled>
                                <?php echo $plan['status'] == 'active' ? 'Disable' : 'Enable'; ?>
                            </button>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- Payment Settings -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Payment Settings</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="form-label">Payment Gateways</label>
                    <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="stripe_enabled" checked disabled>
                        <label class="form-check-label" for="stripe_enabled">Stripe</label>
                    </div>
                    <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="paypal_enabled" disabled>
                        <label class="form-check-label" for="paypal_enabled">PayPal</label>
                    </div>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="bank_transfer_enabled" disabled>
                        <label class="form-check-label" for="bank_transfer_enabled">Bank Transfer</label>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Currency</label>
                    <select class="form-select" disabled>
                        <option selected>USD - US Dollar</option>
                        <option>EUR - Euro</option>
                        <option>GBP - British Pound</option>
                    </select>
                </div>
                
                <button class="btn btn-outline-primary w-100" disabled>
                    <i class="fas fa-cog me-2"></i>Configure Payment Settings
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Approve Payment Modal -->
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Approve Payment</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="?action=payment">
                <div class="modal-body">
                    <input type="hidden" name="action" value="update_payment_status">
                    <input type="hidden" name="id" id="approve_payment_id">
                    <input type="hidden" name="status" value="completed">
                    
                    <p>Are you sure you want to approve this payment?</p>
                    <p class="text-muted">This will activate the user's subscription.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Approve Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Refund Modal -->
<div class="modal fade" id="refundModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Process Refund</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="?action=payment">
                <div class="modal-body">
                    <input type="hidden" name="action" value="process_refund">
                    <input type="hidden" name="id" id="refund_payment_id">
                    
                    <div class="mb-3">
                        <label for="refund_amount" class="form-label">Refund Amount</label>
                        <input type="number" class="form-control" id="refund_amount" name="refund_amount" 
                               step="0.01" min="0" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="refund_reason" class="form-label">Refund Reason</label>
                        <textarea class="form-control" id="refund_reason" name="refund_reason" 
                                  rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning">Process Refund</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Approve payment modal
    const approveModal = document.getElementById('approveModal');
    if (approveModal) {
        approveModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            const paymentId = button.getAttribute('data-payment-id');
            document.getElementById('approve_payment_id').value = paymentId;
        });
    }
    
    // Refund modal
    const refundModal = document.getElementById('refundModal');
    if (refundModal) {
        refundModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            const paymentId = button.getAttribute('data-payment-id');
            document.getElementById('refund_payment_id').value = paymentId;
        });
    }
});
</script>