<?php
// Handle AI operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=ai&error=Database not available');
    exit;
}

try {
    // Handle AI settings update
    if ($_POST['action'] === 'update_ai_settings') {
        foreach ($_POST['settings'] as $key => $value) {
            // Check if setting exists
            $checkQuery = "SELECT COUNT(*) as count FROM ai_settings WHERE setting_key = ?";
            $checkStmt = $db->prepare($checkQuery);
            $checkStmt->execute([$key]);
            $result = $checkStmt->fetch(PDO::FETCH_ASSOC);
            
            if ($result['count'] > 0) {
                // Update existing setting
                $query = "UPDATE ai_settings SET setting_value = ?, updated_at = NOW() WHERE setting_key = ?";
                $stmt = $db->prepare($query);
                $stmt->execute([$value, $key]);
            } else {
                // Insert new setting
                $query = "INSERT INTO ai_settings (setting_key, setting_value, created_at) VALUES (?, ?, NOW())";
                $stmt = $db->prepare($query);
                $stmt->execute([$key, $value]);
            }
        }
        
        header('Location: ?action=ai&success=1');
        exit;
    }

    // Handle AI content generation
    if ($_POST['action'] === 'generate_content') {
        $content_type = $_POST['content_type'] ?? '';
        $topic = $_POST['topic'] ?? '';
        $level = $_POST['level'] ?? 'B1';
        $skill_type = $_POST['skill_type'] ?? 'reading';
        
        if (!empty($topic)) {
            // Simulate AI content generation (in a real system, this would call an AI API)
            $generated_content = "This is AI-generated content about: " . htmlspecialchars($topic) . 
                                " for " . $level . " level " . $skill_type . " practice.";
            
            // Store the generated content temporarily in session
            $_SESSION['ai_generated_content'] = $generated_content;
            $_SESSION['ai_content_topic'] = $topic;
            $_SESSION['ai_content_type'] = $content_type;
            
            header('Location: ?action=ai&generated=1');
            exit;
        }
    }
} catch (Exception $e) {
    header('Location: ?action=ai&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=ai&error=Invalid operation');
exit;
?>