<?php
// Handle category operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=categories&error=Database not available');
    exit;
}

try {
    // Handle create/update
    if ($_POST['action'] === 'create_category') {
        $name = $_POST['name'] ?? '';
        $description = $_POST['description'] ?? '';
        $type = $_POST['type'] ?? 'post';
        $status = $_POST['status'] ?? 'active';
        
        if (!empty($name)) {
            $query = "INSERT INTO categories (name, description, type, status, created_at) VALUES (?, ?, ?, ?, NOW())";
            $stmt = $db->prepare($query);
            $stmt->execute([$name, $description, $type, $status]);
            
            header('Location: ?action=categories&success=1');
            exit;
        }
    }
    
    if ($_POST['action'] === 'update_category') {
        $id = $_POST['id'] ?? '';
        $name = $_POST['name'] ?? '';
        $description = $_POST['description'] ?? '';
        $type = $_POST['type'] ?? 'post';
        $status = $_POST['status'] ?? 'active';
        
        if (!empty($id) && !empty($name)) {
            $query = "UPDATE categories SET name = ?, description = ?, type = ?, status = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$name, $description, $type, $status, $id]);
            
            header('Location: ?action=categories&success=1');
            exit;
        }
    }

    // Handle delete
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        
        // Check if category is in use
        $checkQuery = "SELECT COUNT(*) as count FROM posts WHERE category_id = ?";
        $checkStmt = $db->prepare($checkQuery);
        $checkStmt->execute([$id]);
        $result = $checkStmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result['count'] > 0) {
            header('Location: ?action=categories&error=Category is in use and cannot be deleted');
            exit;
        }
        
        $query = "DELETE FROM categories WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=categories&success=1');
        exit;
    }
} catch (Exception $e) {
    header('Location: ?action=categories&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=categories&error=Invalid operation');
exit;
?>