<?php
// Handle course operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=courses&error=Database not available');
    exit;
}

try {
    // Handle create/update
    if ($_POST['action'] === 'create_course') {
        $title = $_POST['title'] ?? '';
        $description = $_POST['description'] ?? '';
        $level = $_POST['level'] ?? 'A1';
        $skill_type = $_POST['skill_type'] ?? 'reading';
        $status = $_POST['status'] ?? 'draft';
        
        if (!empty($title)) {
            $query = "INSERT INTO courses (title, description, level, skill_type, status, created_at) 
                      VALUES (?, ?, ?, ?, ?, NOW())";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $description, $level, $skill_type, $status]);
            
            header('Location: ?action=courses&success=1');
            exit;
        }
    }
    
    if ($_POST['action'] === 'update_course') {
        $id = $_POST['id'] ?? '';
        $title = $_POST['title'] ?? '';
        $description = $_POST['description'] ?? '';
        $level = $_POST['level'] ?? 'A1';
        $skill_type = $_POST['skill_type'] ?? 'reading';
        $status = $_POST['status'] ?? 'draft';
        
        if (!empty($id) && !empty($title)) {
            $query = "UPDATE courses SET title = ?, description = ?, level = ?, skill_type = ?, 
                      status = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $description, $level, $skill_type, $status, $id]);
            
            header('Location: ?action=courses&success=1');
            exit;
        }
    }

    // Handle delete
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        $query = "DELETE FROM courses WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=courses&success=1');
        exit;
    }
} catch (Exception $e) {
    header('Location: ?action=courses&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=courses&error=Invalid operation');
exit;
?>