<?php
// Handle language operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=language&error=Database not available');
    exit;
}

try {
    // Handle add language
    if ($_POST['action'] === 'add_language') {
        $name = $_POST['name'] ?? '';
        $code = $_POST['code'] ?? '';
        $locale = $_POST['locale'] ?? '';
        $status = $_POST['status'] ?? 'active';
        
        if (!empty($name) && !empty($code)) {
            $query = "INSERT INTO languages (name, code, locale, status, created_at) 
                      VALUES (?, ?, ?, ?, NOW())";
            $stmt = $db->prepare($query);
            $stmt->execute([$name, $code, $locale, $status]);
            
            header('Location: ?action=language&success=1');
            exit;
        }
    }
    
    // Handle update language
    if ($_POST['action'] === 'update_language') {
        $id = $_POST['id'] ?? '';
        $name = $_POST['name'] ?? '';
        $code = $_POST['code'] ?? '';
        $locale = $_POST['locale'] ?? '';
        $status = $_POST['status'] ?? 'active';
        
        if (!empty($id) && !empty($name) && !empty($code)) {
            $query = "UPDATE languages SET name = ?, code = ?, locale = ?, status = ?, 
                      updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$name, $code, $locale, $status, $id]);
            
            header('Location: ?action=language&success=1');
            exit;
        }
    }

    // Handle set default language
    if ($_GET['set_default'] ?? '') {
        $code = $_GET['set_default'];
        
        // Update settings
        $query = "INSERT INTO settings (setting_key, setting_value, updated_at) 
                  VALUES ('default_language', ?, NOW()) 
                  ON DUPLICATE KEY UPDATE setting_value = ?, updated_at = NOW()";
        $stmt = $db->prepare($query);
        $stmt->execute([$code, $code]);
        
        header('Location: ?action=language&success=1');
        exit;
    }

    // Handle delete language
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        $query = "DELETE FROM languages WHERE id = ? AND code != 'en'";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=language&success=1');
        exit;
    }
} catch (Exception $e) {
    header('Location: ?action=language&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=language&error=Invalid operation');
exit;
?>