<?php
// Handle payment operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=payment&error=Database not available');
    exit;
}

try {
    // Handle payment status update
    if ($_POST['action'] === 'update_payment_status') {
        $id = $_POST['id'] ?? '';
        $status = $_POST['status'] ?? '';
        
        if (!empty($id) && !empty($status)) {
            $query = "UPDATE payments SET status = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$status, $id]);
            
            header('Location: ?action=payment&success=1');
            exit;
        }
    }

    // Handle refund
    if ($_POST['action'] === 'process_refund') {
        $id = $_POST['id'] ?? '';
        $refund_amount = $_POST['refund_amount'] ?? '';
        $refund_reason = $_POST['refund_reason'] ?? '';
        
        if (!empty($id) && !empty($refund_amount)) {
            // Update payment status to refunded
            $query = "UPDATE payments SET status = 'refunded', refund_amount = ?, 
                      refund_reason = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$refund_amount, $refund_reason, $id]);
            
            header('Location: ?action=payment&success=1');
            exit;
        }
    }

    // Handle subscription plan update
    if ($_POST['action'] === 'update_plan') {
        $id = $_POST['id'] ?? '';
        $name = $_POST['name'] ?? '';
        $price = $_POST['price'] ?? '';
        $duration = $_POST['duration'] ?? '';
        $status = $_POST['status'] ?? '';
        
        if (!empty($id) && !empty($name)) {
            $query = "UPDATE subscription_plans SET name = ?, price = ?, duration_days = ?, 
                      status = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$name, $price, $duration, $status, $id]);
            
            header('Location: ?action=payment&success=1');
            exit;
        }
    }
} catch (Exception $e) {
    header('Location: ?action=payment&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=payment&error=Invalid operation');
exit;
?>