<?php
// Handle post operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=posts&error=Database not available');
    exit;
}

try {
    // Handle create/update
    if ($_POST['action'] === 'create_post') {
        $title = $_POST['title'] ?? '';
        $content = $_POST['content'] ?? '';
        $status = $_POST['status'] ?? 'draft';
        $category_id = $_POST['category_id'] ?? null;
        
        if (!empty($title) && !empty($content)) {
            $query = "INSERT INTO posts (title, content, status, category_id, created_at) VALUES (?, ?, ?, ?, NOW())";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $content, $status, $category_id]);
            
            header('Location: ?action=posts&success=1');
            exit;
        }
    }
    
    if ($_POST['action'] === 'update_post') {
        $id = $_POST['id'] ?? '';
        $title = $_POST['title'] ?? '';
        $content = $_POST['content'] ?? '';
        $status = $_POST['status'] ?? 'draft';
        $category_id = $_POST['category_id'] ?? null;
        
        if (!empty($id) && !empty($title) && !empty($content)) {
            $query = "UPDATE posts SET title = ?, content = ?, status = ?, category_id = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $content, $status, $category_id, $id]);
            
            header('Location: ?action=posts&success=1');
            exit;
        }
    }

    // Handle delete
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        $query = "DELETE FROM posts WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=posts&success=1');
        exit;
    }
} catch (Exception $e) {
    header('Location: ?action=posts&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=posts&error=Invalid operation');
exit;
?>