<?php
// Handle settings operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=settings&error=Database not available');
    exit;
}

try {
    if ($_POST['action'] === 'update_settings') {
        foreach ($_POST['settings'] as $key => $value) {
            // Check if setting exists
            $checkQuery = "SELECT COUNT(*) as count FROM settings WHERE setting_key = ?";
            $checkStmt = $db->prepare($checkQuery);
            $checkStmt->execute([$key]);
            $result = $checkStmt->fetch(PDO::FETCH_ASSOC);
            
            if ($result['count'] > 0) {
                // Update existing setting
                $query = "UPDATE settings SET setting_value = ?, updated_at = NOW() WHERE setting_key = ?";
                $stmt = $db->prepare($query);
                $stmt->execute([$value, $key]);
            } else {
                // Insert new setting
                $query = "INSERT INTO settings (setting_key, setting_value, created_at) VALUES (?, ?, NOW())";
                $stmt = $db->prepare($query);
                $stmt->execute([$key, $value]);
            }
        }
        
        header('Location: ?action=settings&success=1');
        exit;
    }
} catch (Exception $e) {
    header('Location: ?action=settings&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=settings&error=Invalid operation');
exit;
?>