<?php
session_start();
// Check if user is logged in and has completed placement test
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

$userLevel = $_SESSION['user_level'] ?? 'A1';
$learningPath = $_SESSION['learning_path'] ?? [];

// Convert level to display name
$levelNames = [
    'A1' => 'Beginner',
    'A2' => 'Elementary',
    'B1' => 'Intermediate',
    'B2' => 'Upper Intermediate',
    'C1' => 'Advanced',
    'C2' => 'Proficient'
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Dashboard | Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/dashboard.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">Simturax English</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="logout.php">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container-fluid mt-4">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 d-md-block sidebar">
                <div class="position-sticky">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="dashboard.php">
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="learning.php?skill=reading">
                                Reading Skills
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="learning.php?skill=speaking">
                                Speaking Skills
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="learning.php?skill=writing">
                                Writing Skills
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="learning.php?skill=grammar">
                                Grammar
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="learning.php?skill=vocabulary">
                                Expand Vocabulary
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main content -->
            <div class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">My Learning Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <span class="btn btn-sm btn-outline-secondary">Level: <?php echo $levelNames[$userLevel]; ?></span>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Progress Overview -->
                    <div class="col-md-8">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5>Your Learning Path</h5>
                            </div>
                            <div class="card-body">
                                <div class="learning-path">
                                    <?php foreach ($learningPath as $skill => $progress): ?>
                                    <div class="skill-progress mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="skill-name"><?php echo ucfirst($skill); ?></span>
                                            <span class="skill-percentage"><?php echo $progress; ?>%</span>
                                        </div>
                                        <div class="progress">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: <?php echo $progress; ?>%"></div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recommended Content -->
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5>Recommended for You</h5>
                            </div>
                            <div class="card-body">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">
                                        <a href="learning.php?skill=grammar&lesson=1">Basic Tenses Review</a>
                                    </li>
                                    <li class="list-group-item">
                                        <a href="learning.php?skill=vocabulary&lesson=2">Everyday Vocabulary</a>
                                    </li>
                                    <li class="list-group-item">
                                        <a href="learning.php?skill=reading&lesson=1">Simple Stories</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>