<?php
// Sample courses data - in real app, this would come from database
$courses = [
    [
        'id' => 1,
        'title' => 'Beginner English Foundation',
        'description' => 'Build your English foundation with basic vocabulary, grammar, and conversation skills.',
        'level' => 'A1',
        'duration' => '6 weeks',
        'lessons' => 24,
        'students' => 1250,
        'rating' => 4.8,
        'image' => '/assets/images/course-beginner.jpg',
        'skills' => ['Vocabulary', 'Basic Grammar', 'Simple Conversations'],
        'price' => 0,
        'featured' => true
    ],
    [
        'id' => 2,
        'title' => 'Intermediate Communication',
        'description' => 'Improve your speaking and listening skills for everyday situations and travel.',
        'level' => 'B1',
        'duration' => '8 weeks',
        'lessons' => 32,
        'students' => 890,
        'rating' => 4.7,
        'image' => '/assets/images/course-intermediate.jpg',
        'skills' => ['Conversation', 'Listening', 'Pronunciation'],
        'price' => 49.99,
        'featured' => false
    ],
    [
        'id' => 3,
        'title' => 'Advanced Business English',
        'description' => 'Master professional communication for meetings, presentations, and emails.',
        'level' => 'C1',
        'duration' => '10 weeks',
        'lessons' => 40,
        'students' => 456,
        'rating' => 4.9,
        'image' => '/assets/images/course-business.jpg',
        'skills' => ['Business Writing', 'Presentations', 'Negotiation'],
        'price' => 99.99,
        'featured' => true
    ],
    [
        'id' => 4,
        'title' => 'English Grammar Mastery',
        'description' => 'Comprehensive grammar course covering all tenses, structures, and usage.',
        'level' => 'B2',
        'duration' => '6 weeks',
        'lessons' => 28,
        'students' => 1200,
        'rating' => 4.6,
        'image' => '/assets/images/course-grammar.jpg',
        'skills' => ['Grammar', 'Sentence Structure', 'Writing'],
        'price' => 39.99,
        'featured' => false
    ],
    [
        'id' => 5,
        'title' => 'Academic Writing Skills',
        'description' => 'Learn to write essays, reports, and research papers in academic English.',
        'level' => 'C1',
        'duration' => '8 weeks',
        'lessons' => 36,
        'students' => 320,
        'rating' => 4.8,
        'image' => '/assets/images/course-writing.jpg',
        'skills' => ['Essay Writing', 'Research', 'Academic Vocabulary'],
        'price' => 79.99,
        'featured' => false
    ],
    [
        'id' => 6,
        'title' => 'Conversation & Fluency',
        'description' => 'Practice speaking English fluently with native-like pronunciation and expression.',
        'level' => 'B2',
        'duration' => '6 weeks',
        'lessons' => 24,
        'students' => 780,
        'rating' => 4.7,
        'image' => '/assets/images/course-conversation.jpg',
        'skills' => ['Fluency', 'Pronunciation', 'Idioms'],
        'price' => 59.99,
        'featured' => true
    ]
];

$levels = [
    'A1' => ['name' => 'Beginner', 'color' => 'success'],
    'A2' => ['name' => 'Elementary', 'color' => 'info'],
    'B1' => ['name' => 'Intermediate', 'color' => 'primary'],
    'B2' => ['name' => 'Upper Intermediate', 'color' => 'warning'],
    'C1' => ['name' => 'Advanced', 'color' => 'danger'],
    'C2' => ['name' => 'Proficient', 'color' => 'dark']
];

$skills = ['Vocabulary', 'Grammar', 'Speaking', 'Writing', 'Listening', 'Reading', 'Business', 'Academic'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>English Courses - Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 80px 0;
        }
        .course-card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s;
            overflow: hidden;
        }
        .course-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.15);
        }
        .course-image {
            height: 200px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 3rem;
        }
        .level-badge {
            position: absolute;
            top: 15px;
            right: 15px;
            font-weight: 600;
            padding: 8px 12px;
            border-radius: 20px;
        }
        .price-tag {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 1.1em;
        }
        .skill-tag {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 15px;
            padding: 5px 12px;
            font-size: 0.8em;
            margin: 2px;
        }
        .filter-section {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 25px;
        }
        .stats-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: all 0.3s;
        }
        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.12);
        }
        .stats-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            color: white;
            font-size: 1.8rem;
        }
        .nav-pills .nav-link {
            border-radius: 25px;
            padding: 10px 20px;
            margin: 5px;
            border: 2px solid transparent;
            transition: all 0.3s;
        }
        .nav-pills .nav-link.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-color: #667eea;
        }
        .nav-pills .nav-link:not(.active) {
            border-color: #e9ecef;
        }
        .nav-pills .nav-link:not(.active):hover {
            border-color: #667eea;
            background: #f8f9ff;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
        <div class="container">
            <a class="navbar-brand fw-bold text-primary" href="/">
                <i class="fas fa-graduation-cap me-2"></i>Simturax
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="/">Home</a>
                <a class="nav-link active" href="/courses">Courses</a>
                <a class="nav-link" href="/placement-test">Test</a>
                <a class="nav-link" href="/login">Login</a>
                <a class="nav-link" href="/signup">Sign Up</a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-4 fw-bold mb-4">Master English with Expert Courses</h1>
                    <p class="lead mb-4">Choose from our carefully designed courses for all levels, from beginner to advanced. Learn at your own pace with interactive lessons and personalized feedback.</p>
                    <div class="d-flex gap-3 flex-wrap">
                        <a href="#courses" class="btn btn-light btn-lg px-4">
                            <i class="fas fa-play-circle me-2"></i>Explore Courses
                        </a>
                        <a href="/placement-test" class="btn btn-outline-light btn-lg px-4">
                            <i class="fas fa-clipboard-list me-2"></i>Take Placement Test
                        </a>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="stats-card">
                                <div class="stats-icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <h3 class="fw-bold">50K+</h3>
                                <p class="text-muted mb-0">Students</p>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="stats-card">
                                <div class="stats-icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <h3 class="fw-bold">94%</h3>
                                <p class="text-muted mb-0">Success Rate</p>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="stats-card">
                                <div class="stats-icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <h3 class="fw-bold">24/7</h3>
                                <p class="text-muted mb-0">Access</p>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="stats-card">
                                <div class="stats-icon">
                                    <i class="fas fa-award"></i>
                                </div>
                                <h3 class="fw-bold">A1-C2</h3>
                                <p class="text-muted mb-0">All Levels</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Courses Section -->
    <section id="courses" class="py-5">
        <div class="container">
            <div class="row">
                <!-- Filters Sidebar -->
                <div class="col-lg-3 mb-4">
                    <div class="filter-section sticky-top" style="top: 100px;">
                        <h5 class="fw-bold mb-4">Filter Courses</h5>
                        
                        <!-- Level Filter -->
                        <div class="mb-4">
                            <h6 class="fw-semibold mb-3">English Level</h6>
                            <div class="nav nav-pills flex-column">
                                <a class="nav-link active" href="#" data-level="all">All Levels</a>
                                <?php foreach ($levels as $code => $level): ?>
                                <a class="nav-link" href="#" data-level="<?php echo $code; ?>">
                                    <?php echo $level['name']; ?> (<?php echo $code; ?>)
                                </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        
                        <!-- Skill Filter -->
                        <div class="mb-4">
                            <h6 class="fw-semibold mb-3">Skills</h6>
                            <div class="d-flex flex-wrap gap-2">
                                <?php foreach ($skills as $skill): ?>
                                <div class="form-check">
                                    <input class="form-check-input skill-filter" type="checkbox" value="<?php echo $skill; ?>" id="skill-<?php echo strtolower($skill); ?>">
                                    <label class="form-check-label small" for="skill-<?php echo strtolower($skill); ?>">
                                        <?php echo $skill; ?>
                                    </label>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        
                        <!-- Price Filter -->
                        <div class="mb-4">
                            <h6 class="fw-semibold mb-3">Price</h6>
                            <div class="nav nav-pills flex-column">
                                <a class="nav-link active" href="#" data-price="all">All Courses</a>
                                <a class="nav-link" href="#" data-price="free">Free Courses</a>
                                <a class="nav-link" href="#" data-price="paid">Paid Courses</a>
                            </div>
                        </div>
                        
                        <button class="btn btn-outline-primary w-100" id="resetFilters">
                            <i class="fas fa-redo me-2"></i>Reset Filters
                        </button>
                    </div>
                </div>
                
                <!-- Courses Grid -->
                <div class="col-lg-9">
                    <!-- Featured Courses -->
                    <div class="mb-5">
                        <h3 class="fw-bold mb-4">Featured Courses</h3>
                        <div class="row g-4">
                            <?php foreach (array_slice($courses, 0, 2) as $course): ?>
                            <?php if ($course['featured']): ?>
                            <div class="col-md-6">
                                <div class="course-card h-100">
                                    <div class="position-relative">
                                        <div class="course-image">
                                            <i class="fas fa-book-open"></i>
                                        </div>
                                        <span class="level-badge bg-<?php echo $levels[$course['level']]['color']; ?>">
                                            <?php echo $course['level']; ?>
                                        </span>
                                        <?php if ($course['price'] == 0): ?>
                                        <span class="price-tag position-absolute" style="bottom: 15px; left: 15px;">
                                            FREE
                                        </span>
                                        <?php else: ?>
                                        <span class="price-tag position-absolute" style="bottom: 15px; left: 15px;">
                                            $<?php echo $course['price']; ?>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="card-body">
                                        <h5 class="card-title fw-bold"><?php echo $course['title']; ?></h5>
                                        <p class="card-text text-muted"><?php echo $course['description']; ?></p>
                                        
                                        <div class="mb-3">
                                            <?php foreach ($course['skills'] as $skill): ?>
                                            <span class="skill-tag d-inline-block"><?php echo $skill; ?></span>
                                            <?php endforeach; ?>
                                        </div>
                                        
                                        <div class="d-flex justify-content-between align-items-center text-muted small mb-3">
                                            <span><i class="fas fa-clock me-1"></i> <?php echo $course['duration']; ?></span>
                                            <span><i class="fas fa-book me-1"></i> <?php echo $course['lessons']; ?> lessons</span>
                                            <span><i class="fas fa-users me-1"></i> <?php echo $course['students']; ?> students</span>
                                        </div>
                                        
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="text-warning">
                                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                                <i class="fas fa-star<?php echo $i <= floor($course['rating']) ? '' : '-half-alt'; ?>"></i>
                                                <?php endfor; ?>
                                                <small class="text-muted ms-1">(<?php echo $course['rating']; ?>)</small>
                                            </div>
                                            <a href="/course/<?php echo $course['id']; ?>" class="btn btn-primary">
                                                <i class="fas fa-play-circle me-2"></i>Start Learning
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    
                    <!-- All Courses -->
                    <div>
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h3 class="fw-bold mb-0">All English Courses</h3>
                            <div class="dropdown">
                                <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                    <i class="fas fa-sort me-2"></i>Sort By
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="#" data-sort="popular">Most Popular</a></li>
                                    <li><a class="dropdown-item" href="#" data-sort="rating">Highest Rated</a></li>
                                    <li><a class="dropdown-item" href="#" data-sort="newest">Newest First</a></li>
                                    <li><a class="dropdown-item" href="#" data-sort="price-low">Price: Low to High</a></li>
                                    <li><a class="dropdown-item" href="#" data-sort="price-high">Price: High to Low</a></li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="row g-4" id="coursesGrid">
                            <?php foreach ($courses as $course): ?>
                            <div class="col-lg-4 col-md-6" data-level="<?php echo $course['level']; ?>" 
                                 data-price="<?php echo $course['price'] == 0 ? 'free' : 'paid'; ?>"
                                 data-skills="<?php echo implode(',', $course['skills']); ?>">
                                <div class="course-card h-100">
                                    <div class="position-relative">
                                        <div class="course-image">
                                            <i class="fas fa-book-open"></i>
                                        </div>
                                        <span class="level-badge bg-<?php echo $levels[$course['level']]['color']; ?>">
                                            <?php echo $course['level']; ?>
                                        </span>
                                        <?php if ($course['price'] == 0): ?>
                                        <span class="price-tag position-absolute" style="bottom: 15px; left: 15px;">
                                            FREE
                                        </span>
                                        <?php else: ?>
                                        <span class="price-tag position-absolute" style="bottom: 15px; left: 15px;">
                                            $<?php echo $course['price']; ?>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="card-body">
                                        <h6 class="card-title fw-bold"><?php echo $course['title']; ?></h6>
                                        <p class="card-text text-muted small"><?php echo $course['description']; ?></p>
                                        
                                        <div class="mb-3">
                                            <?php foreach (array_slice($course['skills'], 0, 2) as $skill): ?>
                                            <span class="skill-tag d-inline-block"><?php echo $skill; ?></span>
                                            <?php endforeach; ?>
                                            <?php if (count($course['skills']) > 2): ?>
                                            <span class="skill-tag d-inline-block">+<?php echo count($course['skills']) - 2; ?> more</span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="d-flex justify-content-between align-items-center text-muted small mb-3">
                                            <span><i class="fas fa-clock me-1"></i> <?php echo $course['duration']; ?></span>
                                            <span><i class="fas fa-book me-1"></i> <?php echo $course['lessons']; ?></span>
                                        </div>
                                        
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="text-warning small">
                                                <i class="fas fa-star"></i> <?php echo $course['rating']; ?>
                                            </div>
                                            <a href="/course/<?php echo $course['id']; ?>" class="btn btn-outline-primary btn-sm">
                                                View Course
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <h2 class="fw-bold mb-3">Not Sure Where to Start?</h2>
                    <p class="lead mb-4">Take our free placement test to discover your exact English level and get personalized course recommendations.</p>
                    <a href="/placement-test" class="btn btn-primary btn-lg px-5">
                        <i class="fas fa-clipboard-list me-2"></i>Take Free Placement Test
                    </a>
                </div>
            </div>
        </div>
    </section>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Course filtering functionality
        document.addEventListener('DOMContentLoaded', function() {
            let currentLevel = 'all';
            let currentPrice = 'all';
            let selectedSkills = [];
            let currentSort = 'popular';
            
            // Level filter
            document.querySelectorAll('[data-level]').forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    document.querySelectorAll('[data-level]').forEach(l => l.classList.remove('active'));
                    this.classList.add('active');
                    currentLevel = this.getAttribute('data-level');
                    filterCourses();
                });
            });
            
            // Price filter
            document.querySelectorAll('[data-price]').forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    document.querySelectorAll('[data-price]').forEach(l => l.classList.remove('active'));
                    this.classList.add('active');
                    currentPrice = this.getAttribute('data-price');
                    filterCourses();
                });
            });
            
            // Skill filter
            document.querySelectorAll('.skill-filter').forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    selectedSkills = Array.from(document.querySelectorAll('.skill-filter:checked'))
                                        .map(cb => cb.value);
                    filterCourses();
                });
            });
            
            // Sort functionality
            document.querySelectorAll('[data-sort]').forEach(item => {
                item.addEventListener('click', function(e) {
                    e.preventDefault();
                    currentSort = this.getAttribute('data-sort');
                    sortCourses();
                });
            });
            
            // Reset filters
            document.getElementById('resetFilters').addEventListener('click', function() {
                currentLevel = 'all';
                currentPrice = 'all';
                selectedSkills = [];
                currentSort = 'popular';
                
                document.querySelectorAll('[data-level]').forEach(l => l.classList.remove('active'));
                document.querySelector('[data-level="all"]').classList.add('active');
                
                document.querySelectorAll('[data-price]').forEach(l => l.classList.remove('active'));
                document.querySelector('[data-price="all"]').classList.add('active');
                
                document.querySelectorAll('.skill-filter').forEach(cb => cb.checked = false);
                
                filterCourses();
                sortCourses();
            });
            
            function filterCourses() {
                const courses = document.querySelectorAll('#coursesGrid > div');
                
                courses.forEach(course => {
                    const level = course.getAttribute('data-level');
                    const price = course.getAttribute('data-price');
                    const skills = course.getAttribute('data-skills').split(',');
                    
                    let showCourse = true;
                    
                    // Level filter
                    if (currentLevel !== 'all' && level !== currentLevel) {
                        showCourse = false;
                    }
                    
                    // Price filter
                    if (currentPrice !== 'all' && price !== currentPrice) {
                        showCourse = false;
                    }
                    
                    // Skills filter
                    if (selectedSkills.length > 0) {
                        const hasMatchingSkill = selectedSkills.some(skill => skills.includes(skill));
                        if (!hasMatchingSkill) {
                            showCourse = false;
                        }
                    }
                    
                    course.style.display = showCourse ? 'block' : 'none';
                });
            }
            
            function sortCourses() {
                // In a real application, this would re-sort the courses based on the selected criteria
                // For now, we'll just show a message
                console.log('Sorting by:', currentSort);
            }
        });
    </script>
</body>
</html>