<?php
// Get current language from session or default to English
$current_language = $_SESSION['language'] ?? 'en';
$languages = [
    'en' => 'English',
    'es' => 'Espaol',
    'fr' => 'Franais',
    'de' => 'Deutsch'
];

// Dark mode handling
$dark_mode = $_COOKIE['dark_mode'] ?? 'false';
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="<?php echo $dark_mode === 'true' ? 'dark' : 'light'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Learn English Online - Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #667eea;
            --secondary-color: #764ba2;
            --accent-color: #f093fb;
        }
        
        .hero-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><polygon fill="rgba(255,255,255,0.05)" points="0,1000 1000,0 1000,1000"/></svg>');
            background-size: cover;
        }
        
        .feature-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            color: white;
            font-size: 2rem;
        }
        
        .category-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: none;
            border-radius: 15px;
            overflow: hidden;
        }
        
        .category-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .category-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            color: var(--primary-color);
        }
        
        .testimonial-card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }
        
        .testimonial-card:hover {
            transform: translateY(-5px);
        }
        
        .testimonial-avatar {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            object-fit: cover;
        }
        
        .cta-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 80px 0;
            border-radius: 20px;
            margin: 80px 0;
            position: relative;
            overflow: hidden;
        }
        
        .cta-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><circle fill="rgba(255,255,255,0.1)" cx="200" cy="200" r="100"/><circle fill="rgba(255,255,255,0.05)" cx="800" cy="800" r="150"/></svg>');
        }
        
        .nav-link {
            font-weight: 500;
            transition: color 0.3s ease;
        }
        
        .nav-link:hover {
            color: var(--primary-color) !important;
        }
        
        .btn-gradient {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border: none;
            color: white;
            font-weight: 600;
            padding: 12px 30px;
            border-radius: 50px;
            transition: all 0.3s ease;
        }
        
        .btn-gradient:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .btn-outline-gradient {
            border: 2px solid transparent;
            background: linear-gradient(white, white) padding-box,
                        linear-gradient(135deg, var(--primary-color), var(--secondary-color)) border-box;
            color: var(--primary-color);
            font-weight: 600;
            padding: 10px 28px;
            border-radius: 50px;
            transition: all 0.3s ease;
        }
        
        .btn-outline-gradient:hover {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            transform: translateY(-2px);
        }
        
        [data-bs-theme="dark"] .btn-outline-gradient {
            background: linear-gradient(var(--bs-dark), var(--bs-dark)) padding-box,
                        linear-gradient(135deg, var(--primary-color), var(--secondary-color)) border-box;
            color: white;
        }
        
        [data-bs-theme="dark"] .btn-outline-gradient:hover {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        }
        
        .language-dropdown .dropdown-menu {
            min-width: 150px;
        }
        
        .dark-mode-toggle {
            cursor: pointer;
            padding: 8px;
            border-radius: 50%;
            transition: background-color 0.3s ease;
        }
        
        .dark-mode-toggle:hover {
            background-color: rgba(0,0,0,0.1);
        }
        
        .faq-item {
            border: none;
            border-radius: 10px;
            margin-bottom: 10px;
            overflow: hidden;
        }
        
        .faq-button {
            background: var(--bs-body-bg);
            border: none;
            padding: 20px;
            text-align: left;
            font-weight: 600;
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        
        .faq-button:not(.collapsed) {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
        }
        
        .stats-number {
            font-size: 3rem;
            font-weight: 700;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .floating-shapes {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
        }
        
        .floating-shape {
            position: absolute;
            opacity: 0.1;
            animation: float 6s ease-in-out infinite;
        }
        
        .floating-shape:nth-child(1) { top: 20%; left: 10%; animation-delay: 0s; }
        .floating-shape:nth-child(2) { top: 60%; left: 80%; animation-delay: 2s; }
        .floating-shape:nth-child(3) { top: 40%; left: 70%; animation-delay: 4s; }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }
        
        .level-badge {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="sticky-top bg-body shadow-sm">
        <div class="container">
            <nav class="navbar navbar-expand-lg navbar-light py-3">
                <!-- Site Icon and Brand -->
                <a class="navbar-brand fw-bold d-flex align-items-center" href="/" style="color: var(--primary-color);">
                    <i class="fas fa-graduation-cap me-2 fs-3"></i>
                    <span class="fs-4">Simturax</span>
                </a>

                <!-- Mobile Toggle -->
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <!-- Navigation Menu -->
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav mx-auto">
                        <li class="nav-item">
                            <a class="nav-link active" href="/">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="/courses">Courses</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="/placement-test">Placement Test</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="/pricing">Pricing</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="/about">About</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="/contact">Contact</a>
                        </li>
                    </ul>

                    <!-- Right Side Items -->
                    <div class="d-flex align-items-center">
                        <!-- Language Toggle -->
                        <div class="dropdown language-dropdown me-3">
                            <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-globe me-1"></i>
                                <?php echo $languages[$current_language] ?? 'English'; ?>
                            </button>
                            <ul class="dropdown-menu">
                                <?php foreach ($languages as $code => $name): ?>
                                <li>
                                    <a class="dropdown-item <?php echo $current_language === $code ? 'active' : ''; ?>" 
                                       href="?lang=<?php echo $code; ?>">
                                        <?php echo $name; ?>
                                    </a>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>

                        <!-- Dark Mode Toggle -->
                        <div class="dark-mode-toggle me-3" id="darkModeToggle">
                            <i class="fas fa-moon fs-5"></i>
                        </div>

                        <!-- Login/Signup Buttons -->
                        <div class="btn-group">
                            <a href="/login" class="btn btn-outline-primary">Login</a>
                            <a href="/signup" class="btn btn-gradient">Sign Up</a>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="floating-shapes">
            <div class="floating-shape">
                <i class="fas fa-comment-dots fa-3x"></i>
            </div>
            <div class="floating-shape">
                <i class="fas fa-book-open fa-3x"></i>
            </div>
            <div class="floating-shape">
                <i class="fas fa-globe-americas fa-3x"></i>
            </div>
        </div>
        
        <div class="container position-relative">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-4 fw-bold mb-4">Master English Your Way</h1>
                    <p class="lead mb-4 fs-5">
                        Personalized learning paths, AI-powered exercises, and native speaker interactions. 
                        Start your journey to fluency with our smart placement test and customized curriculum.
                    </p>
                    <div class="d-flex flex-wrap gap-3">
                        <a href="/placement-test" class="btn btn-gradient btn-lg">
                            <i class="fas fa-play-circle me-2"></i>Take Free Test
                        </a>
                        <a href="/courses" class="btn btn-outline-gradient btn-lg">
                            <i class="fas fa-book me-2"></i>Browse Courses
                        </a>
                    </div>
                    
                    <!-- Stats -->
                    <div class="row mt-5 pt-4">
                        <div class="col-4 text-center">
                            <div class="stats-number">10K+</div>
                            <small class="text-light">Active Learners</small>
                        </div>
                        <div class="col-4 text-center">
                            <div class="stats-number">500+</div>
                            <small class="text-light">Learning Hours</small>
                        </div>
                        <div class="col-4 text-center">
                            <div class="stats-number">98%</div>
                            <small class="text-light">Success Rate</small>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <div class="position-relative">
                        <img src="https://images.unsplash.com/photo-1522202176988-66273c2fd55f?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                             alt="Students learning English" class="img-fluid rounded-3 shadow-lg" 
                             style="max-height: 500px; object-fit: cover;">
                        <div class="position-absolute top-0 start-0 mt-3 ms-3">
                            <span class="level-badge">A1-C2 Levels</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row justify-content-center mb-5">
                <div class="col-lg-8 text-center">
                    <h2 class="display-5 fw-bold mb-3">Why Choose Simturax?</h2>
                    <p class="lead text-muted">Experience the future of English learning with our innovative platform</p>
                </div>
            </div>
            
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-brain"></i>
                        </div>
                        <h4 class="fw-bold mb-3">AI-Powered Learning</h4>
                        <p class="text-muted">
                            Smart algorithms adapt to your learning style and pace, providing personalized 
                            exercises and real-time feedback.
                        </p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <h4 class="fw-bold mb-3">Progress Tracking</h4>
                        <p class="text-muted">
                            Monitor your improvement with detailed analytics, progress reports, and 
                            achievement milestones.
                        </p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <h4 class="fw-bold mb-3">Native Speakers</h4>
                        <p class="text-muted">
                            Practice with certified native English teachers and connect with learners 
                            from around the world.
                        </p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-mobile-alt"></i>
                        </div>
                        <h4 class="fw-bold mb-3">Learn Anywhere</h4>
                        <p class="text-muted">
                            Access your lessons on any device. Continue learning offline and sync 
                            progress when you're back online.
                        </p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-gamepad"></i>
                        </div>
                        <h4 class="fw-bold mb-3">Gamified Learning</h4>
                        <p class="text-muted">
                            Earn points, unlock achievements, and compete with friends while mastering 
                            English skills.
                        </p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-certificate"></i>
                        </div>
                        <h4 class="fw-bold mb-3">Certification</h4>
                        <p class="text-muted">
                            Receive recognized certificates for each level you complete, validating 
                            your English proficiency.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Categories Section -->
    <section class="py-5">
        <div class="container">
            <div class="row justify-content-center mb-5">
                <div class="col-lg-8 text-center">
                    <h2 class="display-5 fw-bold mb-3">Master Every Skill</h2>
                    <p class="lead text-muted">Comprehensive courses covering all aspects of English language learning</p>
                </div>
            </div>
            
            <div class="row g-4">
                <!-- Vocabulary -->
                <div class="col-md-4">
                    <a href="/learning/vocabulary" class="text-decoration-none">
                        <div class="card category-card h-100 text-center p-4">
                            <div class="category-icon">
                                <i class="fas fa-book"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Vocabulary</h4>
                            <p class="text-muted mb-0">
                                Expand your word power with thematic vocabulary lessons, 
                                idioms, and expressions for real-life situations.
                            </p>
                            <div class="mt-3">
                                <span class="badge bg-primary">1,200+ Words</span>
                            </div>
                        </div>
                    </a>
                </div>
                
                <!-- Reading Skills -->
                <div class="col-md-4">
                    <a href="/learning/reading" class="text-decoration-none">
                        <div class="card category-card h-100 text-center p-4">
                            <div class="category-icon">
                                <i class="fas fa-book-open"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Reading Skills</h4>
                            <p class="text-muted mb-0">
                                Improve comprehension with engaging articles, stories, 
                                and exercises tailored to your level.
                            </p>
                            <div class="mt-3">
                                <span class="badge bg-success">300+ Texts</span>
                            </div>
                        </div>
                    </a>
                </div>
                
                <!-- Listening Skills -->
                <div class="col-md-4">
                    <a href="/learning/listening" class="text-decoration-none">
                        <div class="card category-card h-100 text-center p-4">
                            <div class="category-icon">
                                <i class="fas fa-headphones"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Listening Skills</h4>
                            <p class="text-muted mb-0">
                                Train your ear with authentic audio materials, podcasts, 
                                and interactive listening exercises.
                            </p>
                            <div class="mt-3">
                                <span class="badge bg-info">500+ Audio</span>
                            </div>
                        </div>
                    </a>
                </div>
                
                <!-- Speaking Skills -->
                <div class="col-md-4">
                    <a href="/learning/speaking" class="text-decoration-none">
                        <div class="card category-card h-100 text-center p-4">
                            <div class="category-icon">
                                <i class="fas fa-microphone"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Speaking Skills</h4>
                            <p class="text-muted mb-0">
                                Build confidence with pronunciation practice, 
                                conversation simulations, and speech recognition.
                            </p>
                            <div class="mt-3">
                                <span class="badge bg-warning">AI Feedback</span>
                            </div>
                        </div>
                    </a>
                </div>
                
                <!-- Writing Skills -->
                <div class="col-md-4">
                    <a href="/learning/writing" class="text-decoration-none">
                        <div class="card category-card h-100 text-center p-4">
                            <div class="category-icon">
                                <i class="fas fa-pencil-alt"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Writing Skills</h4>
                            <p class="text-muted mb-0">
                                Master different writing styles from emails to essays 
                                with guided exercises and expert feedback.
                            </p>
                            <div class="mt-3">
                                <span class="badge bg-danger">100+ Templates</span>
                            </div>
                        </div>
                    </a>
                </div>
                
                <!-- Grammar -->
                <div class="col-md-4">
                    <a href="/learning/grammar" class="text-decoration-none">
                        <div class="card category-card h-100 text-center p-4">
                            <div class="category-icon">
                                <i class="fas fa-language"></i>
                            </div>
                            <h4 class="fw-bold mb-3">Grammar</h4>
                            <p class="text-muted mb-0">
                                Understand English grammar rules through interactive 
                                lessons, practice exercises, and real-world examples.
                            </p>
                            <div class="mt-3">
                                <span class="badge bg-secondary">50+ Lessons</span>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row justify-content-center mb-5">
                <div class="col-lg-8 text-center">
                    <h2 class="display-5 fw-bold mb-3">Frequently Asked Questions</h2>
                    <p class="lead text-muted">Find answers to common questions about our platform</p>
                </div>
            </div>
            
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="accordion" id="faqAccordion">
                        <!-- FAQ 1 -->
                        <div class="accordion-item faq-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button faq-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                    How does the placement test work?
                                </button>
                            </h2>
                            <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Our placement test uses adaptive technology to assess your English level across 
                                    reading, writing, listening, and grammar skills. The test takes about 20 minutes 
                                    and provides immediate results with a personalized learning path.
                                </div>
                            </div>
                        </div>
                        
                        <!-- FAQ 2 -->
                        <div class="accordion-item faq-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button faq-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                    Can I learn on my mobile device?
                                </button>
                            </h2>
                            <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Yes! Our platform is fully responsive and works on all devices - desktop, tablet, 
                                    and mobile. You can also download our mobile app for offline learning capabilities.
                                </div>
                            </div>
                        </div>
                        
                        <!-- FAQ 3 -->
                        <div class="accordion-item faq-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button faq-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                    How long does it take to complete a level?
                                </button>
                            </h2>
                            <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    The time varies depending on your dedication and starting level. On average, 
                                    students complete one CEFR level (A1, A2, B1, etc.) in 2-3 months with regular 
                                    practice of 30 minutes daily.
                                </div>
                            </div>
                        </div>
                        
                        <!-- FAQ 4 -->
                        <div class="accordion-item faq-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button faq-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                                    Are the certificates recognized?
                                </button>
                            </h2>
                            <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Yes, our certificates are aligned with the Common European Framework of Reference 
                                    (CEFR) and are recognized by many educational institutions and employers worldwide.
                                </div>
                            </div>
                        </div>
                        
                        <!-- FAQ 5 -->
                        <div class="accordion-item faq-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button faq-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq5">
                                    Can I get a refund if I'm not satisfied?
                                </button>
                            </h2>
                            <div id="faq5" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    We offer a 30-day money-back guarantee. If you're not satisfied with our platform 
                                    within the first 30 days, we'll provide a full refund, no questions asked.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="py-5">
        <div class="container">
            <div class="row justify-content-center mb-5">
                <div class="col-lg-8 text-center">
                    <h2 class="display-5 fw-bold mb-3">What Learners Say About Us</h2>
                    <p class="lead text-muted">Join thousands of successful English learners worldwide</p>
                </div>
            </div>
            
            <div class="row g-4">
                <!-- Testimonial 1 -->
                <div class="col-md-4">
                    <div class="card testimonial-card h-100">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center mb-3">
                                <img src="https://images.unsplash.com/photo-1494790108755-2616b612b786?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80" 
                                     alt="Maria" class="testimonial-avatar me-3">
                                <div>
                                    <h5 class="fw-bold mb-0">Maria Rodriguez</h5>
                                    <small class="text-muted">From A2 to B2 in 6 months</small>
                                </div>
                            </div>
                            <div class="mb-3">
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                            </div>
                            <p class="text-muted mb-0">
                                "The personalized learning path was exactly what I needed. I went from basic 
                                conversations to confidently participating in business meetings. The speaking 
                                practice with AI feedback was incredible!"
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Testimonial 2 -->
                <div class="col-md-4">
                    <div class="card testimonial-card h-100">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center mb-3">
                                <img src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80" 
                                     alt="Ahmed" class="testimonial-avatar me-3">
                                <div>
                                    <h5 class="fw-bold mb-0">Ahmed Hassan</h5>
                                    <small class="text-muted">From B1 to C1 in 8 months</small>
                                </div>
                            </div>
                            <div class="mb-3">
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                            </div>
                            <p class="text-muted mb-0">
                                "As a medical professional, I needed advanced English for international conferences. 
                                The specialized vocabulary and writing exercises helped me achieve my goals. Highly recommended!"
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Testimonial 3 -->
                <div class="col-md-4">
                    <div class="card testimonial-card h-100">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center mb-3">
                                <img src="https://images.unsplash.com/photo-1438761681033-6461ffad8d80?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80" 
                                     alt="Sophie" class="testimonial-avatar me-3">
                                <div>
                                    <h5 class="fw-bold mb-0">Sophie Chen</h5>
                                    <small class="text-muted">From A1 to B1 in 4 months</small>
                                </div>
                            </div>
                            <div class="mb-3">
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                                <i class="fas fa-star text-warning"></i>
                            </div>
                            <p class="text-muted mb-0">
                                "I tried many apps before finding Simturax. The placement test accurately identified 
                                my level and the gamified lessons kept me motivated. I can now travel confidently!"
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Call to Action Section -->
    <section class="cta-section">
        <div class="container position-relative">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <h2 class="display-5 fw-bold mb-4">Ready to Start Your English Journey?</h2>
                    <p class="lead mb-4 opacity-75">
                        Join 10,000+ learners who have transformed their English skills with our personalized platform. 
                        Start with a free placement test and discover your custom learning path.
                    </p>
                    <div class="d-flex flex-column flex-sm-row justify-content-center gap-3">
                        <a href="/signup" class="btn btn-light btn-lg px-5 py-3 fw-bold" style="color: var(--primary-color);">
                            <i class="fas fa-rocket me-2"></i>Start Learning Free
                        </a>
                        <a href="/placement-test" class="btn btn-outline-light btn-lg px-5 py-3 fw-bold">
                            <i class="fas fa-play-circle me-2"></i>Take Placement Test
                        </a>
                    </div>
                    <p class="mt-3 opacity-75">
                        <small>No credit card required  30-day money-back guarantee</small>
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-dark text-light py-5">
        <div class="container">
            <div class="row g-4">
                <!-- Company Info -->
                <div class="col-lg-4">
                    <div class="d-flex align-items-center mb-3">
                        <i class="fas fa-graduation-cap me-2 fs-3" style="color: var(--primary-color);"></i>
                        <span class="fs-4 fw-bold">Simturax</span>
                    </div>
                    <p class="text-light opacity-75 mb-3">
                        Transforming English learning through AI-powered personalization, 
                        interactive exercises, and real-world practice.
                    </p>
                    <div class="d-flex gap-3">
                        <a href="#" class="text-light opacity-75 hover-primary">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="text-light opacity-75 hover-primary">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="#" class="text-light opacity-75 hover-primary">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="#" class="text-light opacity-75 hover-primary">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                        <a href="#" class="text-light opacity-75 hover-primary">
                            <i class="fab fa-youtube"></i>
                        </a>
                    </div>
                </div>
                
                <!-- Useful Links -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="fw-bold mb-3">Useful Links</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="/about" class="text-light opacity-75 text-decoration-none hover-primary">About Us</a></li>
                        <li class="mb-2"><a href="/courses" class="text-light opacity-75 text-decoration-none hover-primary">All Courses</a></li>
                        <li class="mb-2"><a href="/pricing" class="text-light opacity-75 text-decoration-none hover-primary">Pricing</a></li>
                        <li class="mb-2"><a href="/blog" class="text-light opacity-75 text-decoration-none hover-primary">Blog</a></li>
                        <li class="mb-2"><a href="/careers" class="text-light opacity-75 text-decoration-none hover-primary">Careers</a></li>
                    </ul>
                </div>
                
                <!-- Categories -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="fw-bold mb-3">Categories</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="/learning/vocabulary" class="text-light opacity-75 text-decoration-none hover-primary">Vocabulary</a></li>
                        <li class="mb-2"><a href="/learning/reading" class="text-light opacity-75 text-decoration-none hover-primary">Reading Skills</a></li>
                        <li class="mb-2"><a href="/learning/listening" class="text-light opacity-75 text-decoration-none hover-primary">Listening Skills</a></li>
                        <li class="mb-2"><a href="/learning/speaking" class="text-light opacity-75 text-decoration-none hover-primary">Speaking Skills</a></li>
                        <li class="mb-2"><a href="/learning/writing" class="text-light opacity-75 text-decoration-none hover-primary">Writing Skills</a></li>
                    </ul>
                </div>
                
                <!-- Contact -->
                <div class="col-lg-4">
                    <h5 class="fw-bold mb-3">Contact Us</h5>
                    <ul class="list-unstyled text-light opacity-75">
                        <li class="mb-2">
                            <i class="fas fa-envelope me-2"></i>hello@simturax.com
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-phone me-2"></i>+1 (555) 123-4567
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-map-marker-alt me-2"></i>123 Learning St, Education City
                        </li>
                    </ul>
                    <div class="mt-4">
                        <h6 class="fw-bold mb-2">Subscribe to Newsletter</h6>
                        <div class="input-group">
                            <input type="email" class="form-control" placeholder="Your email">
                            <button class="btn btn-primary" type="button">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <hr class="my-4 opacity-25">
            
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="mb-0 text-light opacity-75">
                        &copy; 2024 Simturax. All rights reserved.
                    </p>
                </div>
                <div class="col-md-6 text-md-end">
                    <a href="/privacy" class="text-light opacity-75 text-decoration-none me-3 hover-primary">Privacy Policy</a>
                    <a href="/terms" class="text-light opacity-75 text-decoration-none me-3 hover-primary">Terms of Service</a>
                    <a href="/cookies" class="text-light opacity-75 text-decoration-none hover-primary">Cookie Policy</a>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Dark Mode Toggle
        document.getElementById('darkModeToggle').addEventListener('click', function() {
            const html = document.documentElement;
            const isDark = html.getAttribute('data-bs-theme') === 'dark';
            const newTheme = isDark ? 'light' : 'dark';
            
            html.setAttribute('data-bs-theme', newTheme);
            document.cookie = `dark_mode=${newTheme === 'dark'}; path=/; max-age=31536000`; // 1 year
            
            // Update icon
            const icon = this.querySelector('i');
            icon.className = newTheme === 'dark' ? 'fas fa-sun fs-5' : 'fas fa-moon fs-5';
        });

        // Language change handler
        document.querySelectorAll('.language-dropdown .dropdown-item').forEach(item => {
            item.addEventListener('click', function(e) {
                e.preventDefault();
                const lang = this.getAttribute('href').split('=')[1];
                
                // In a real application, this would make an AJAX call to set the language
                console.log('Changing language to:', lang);
                // For now, just reload the page with the language parameter
                window.location.href = `?lang=${lang}`;
            });
        });

        // Add hover effect for footer links
        const style = document.createElement('style');
        style.textContent = `
            .hover-primary:hover {
                color: var(--primary-color) !important;
                transition: color 0.3s ease;
            }
        `;
        document.head.appendChild(style);

        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add animation on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe elements for animation
        document.querySelectorAll('.category-card, .testimonial-card, .feature-icon').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(20px)';
            el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
            observer.observe(el);
        });
    </script>
</body>
</html>