<?php
session_start();

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header('Location: /dashboard');
    exit;
}

// Process login form
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // Basic validation
    $errors = [];
    
    if (empty($email)) {
        $errors[] = 'Email is required';
    }
    
    if (empty($password)) {
        $errors[] = 'Password is required';
    }
    
    if (empty($errors)) {
        // In a real application, you would validate against database
        // For demo purposes, we'll use a simple check
        $valid_email = 'student@simturax.com';
        $valid_password = 'password123';
        
        if ($email === $valid_email && $password === $valid_password) {
            $_SESSION['user_id'] = 1;
            $_SESSION['user_email'] = $email;
            $_SESSION['user_name'] = 'Demo Student';
            $_SESSION['user_level'] = 'B1';
            
            header('Location: /dashboard');
            exit;
        } else {
            $errors[] = 'Invalid email or password';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Simturax English Learning</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .login-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .login-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
        }
        .login-body {
            padding: 40px;
        }
        .form-control {
            border-radius: 10px;
            padding: 12px 15px;
            border: 2px solid #e9ecef;
            transition: all 0.3s;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 12px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        .social-login {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 10px;
            text-align: center;
            transition: all 0.3s;
        }
        .social-login:hover {
            border-color: #667eea;
            background: #f8f9ff;
        }
        .feature-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand fw-bold text-primary" href="/">
                <i class="fas fa-graduation-cap me-2"></i>Simturax
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="/">Home</a>
                <a class="nav-link" href="/courses">Courses</a>
                <a class="nav-link" href="/placement-test">Test</a>
                <a class="nav-link active" href="/login">Login</a>
                <a class="nav-link" href="/signup">Sign Up</a>
            </div>
        </div>
    </nav>

    <!-- Login Section -->
    <section class="login-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-10 col-lg-8">
                    <div class="login-card">
                        <div class="row g-0">
                            <!-- Login Form -->
                            <div class="col-md-6">
                                <div class="login-body">
                                    <h3 class="fw-bold mb-1">Welcome Back</h3>
                                    <p class="text-muted mb-4">Sign in to continue your English learning journey</p>
                                    
                                    <?php if (!empty($errors)): ?>
                                    <div class="alert alert-danger">
                                        <?php foreach ($errors as $error): ?>
                                        <div><?php echo htmlspecialchars($error); ?></div>
                                        <?php endforeach; ?>
                                    </div>
                                    <?php endif; ?>

                                    <form method="POST" action="">
                                        <div class="mb-3">
                                            <label for="email" class="form-label">Email Address</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light border-end-0">
                                                    <i class="fas fa-envelope text-muted"></i>
                                                </span>
                                                <input type="email" class="form-control border-start-0" id="email" name="email" 
                                                       value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" 
                                                       placeholder="Enter your email" required>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="password" class="form-label">Password</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light border-end-0">
                                                    <i class="fas fa-lock text-muted"></i>
                                                </span>
                                                <input type="password" class="form-control border-start-0" id="password" name="password" 
                                                       placeholder="Enter your password" required>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3 form-check">
                                            <input type="checkbox" class="form-check-input" id="remember">
                                            <label class="form-check-label" for="remember">Remember me</label>
                                            <a href="/forgot-password" class="float-end text-decoration-none">Forgot password?</a>
                                        </div>
                                        
                                        <button type="submit" class="btn btn-login text-white w-100 mb-3">
                                            Sign In
                                        </button>
                                    </form>
                                    
                                    <div class="text-center mb-3">
                                        <span class="text-muted">Or continue with</span>
                                    </div>
                                    
                                    <div class="row g-2 mb-4">
                                        <div class="col-6">
                                            <a href="#" class="social-login text-decoration-none">
                                                <i class="fab fa-google text-danger me-2"></i>
                                                <span class="text-dark">Google</span>
                                            </a>
                                        </div>
                                        <div class="col-6">
                                            <a href="#" class="social-login text-decoration-none">
                                                <i class="fab fa-facebook text-primary me-2"></i>
                                                <span class="text-dark">Facebook</span>
                                            </a>
                                        </div>
                                    </div>
                                    
                                    <div class="text-center">
                                        <span class="text-muted">Don't have an account? </span>
                                        <a href="/signup" class="text-decoration-none fw-bold">Sign up here</a>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Features Side -->
                            <div class="col-md-6 bg-light">
                                <div class="login-body h-100 d-flex flex-column justify-content-center">
                                    <h4 class="fw-bold mb-4 text-center">Why Learn with Simturax?</h4>
                                    
                                    <div class="row text-center">
                                        <div class="col-12 mb-4">
                                            <div class="feature-icon">
                                                <i class="fas fa-chart-line text-white fa-lg"></i>
                                            </div>
                                            <h6>Personalized Learning</h6>
                                            <p class="text-muted small">AI-powered path based on your level and goals</p>
                                        </div>
                                        
                                        <div class="col-12 mb-4">
                                            <div class="feature-icon">
                                                <i class="fas fa-clock text-white fa-lg"></i>
                                            </div>
                                            <h6>Flexible Schedule</h6>
                                            <p class="text-muted small">Learn at your own pace, anytime, anywhere</p>
                                        </div>
                                        
                                        <div class="col-12 mb-4">
                                            <div class="feature-icon">
                                                <i class="fas fa-trophy text-white fa-lg"></i>
                                            </div>
                                            <h6>Proven Results</h6>
                                            <p class="text-muted small">87% of students improve by 1+ level in 3 months</p>
                                        </div>
                                    </div>
                                    
                                    <div class="mt-4 p-3 bg-white rounded text-center">
                                        <small class="text-muted">
                                            <i class="fas fa-shield-alt text-success me-1"></i>
                                            Your data is securely encrypted and protected
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Demo Credentials Modal -->
    <div class="modal fade" id="demoModal" tabindex="-1">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title">Demo Credentials</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p class="small mb-2"><strong>Email:</strong> student@simturax.com</p>
                    <p class="small mb-0"><strong>Password:</strong> password123</p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Show demo credentials after 3 seconds
        setTimeout(() => {
            const demoModal = new bootstrap.Modal(document.getElementById('demoModal'));
            demoModal.show();
        }, 3000);
    </script>
</body>
</html>