<?php
session_start();

// If user is not logged in, redirect to signup
if (!isset($_SESSION['user_id'])) {
    header('Location: /signup');
    exit;
}

// Sample test questions
$questions = [
    [
        'id' => 1,
        'question' => 'Choose the correct option: I ___ to the store yesterday.',
        'type' => 'multiple_choice',
        'options' => [
            'A' => 'go',
            'B' => 'went',
            'C' => 'gone',
            'D' => 'going'
        ],
        'correct' => 'B',
        'explanation' => 'The past simple tense "went" is used for completed actions in the past.',
        'level' => 'A1'
    ],
    [
        'id' => 2,
        'question' => 'Which sentence is grammatically correct?',
        'type' => 'multiple_choice',
        'options' => [
            'A' => 'She don\'t like coffee.',
            'B' => 'She doesn\'t likes coffee.',
            'C' => 'She doesn\'t like coffee.',
            'D' => 'She not like coffee.'
        ],
        'correct' => 'C',
        'explanation' => 'The third person singular requires "doesn\'t" + base form of the verb.',
        'level' => 'A2'
    ],
    [
        'id' => 3,
        'question' => 'Complete the sentence: If I ___ you, I would take that job.',
        'type' => 'multiple_choice',
        'options' => [
            'A' => 'am',
            'B' => 'was',
            'C' => 'were',
            'D' => 'be'
        ],
        'correct' => 'C',
        'explanation' => 'In hypothetical situations, we use "were" for all subjects.',
        'level' => 'B1'
    ],
    [
        'id' => 4,
        'question' => 'Choose the word that best fits: The company\'s new policy has ___ implications for employees.',
        'type' => 'multiple_choice',
        'options' => [
            'A' => 'far-reaching',
            'B' => 'far-gone',
            'C' => 'far-off',
            'D' => 'far-fetched'
        ],
        'correct' => 'A',
        'explanation' => '"Far-reaching" means having a wide range or effect.',
        'level' => 'B2'
    ],
    [
        'id' => 5,
        'question' => 'Identify the error: Neither the manager nor the employees was aware of the changes.',
        'type' => 'multiple_choice',
        'options' => [
            'A' => 'Neither',
            'B' => 'nor',
            'C' => 'was',
            'D' => 'aware of'
        ],
        'correct' => 'C',
        'explanation' => 'With "neither...nor", the verb agrees with the closer subject ("employees" - plural), so it should be "were".',
        'level' => 'C1'
    ]
];

// Process test submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['answers'])) {
    $user_answers = $_POST['answers'];
    $score = 0;
    $total_questions = count($questions);
    
    // Calculate score
    foreach ($questions as $question) {
        if (isset($user_answers[$question['id']]) && $user_answers[$question['id']] === $question['correct']) {
            $score++;
        }
    }
    
    // Determine level based on score
    $percentage = ($score / $total_questions) * 100;
    
    if ($percentage < 20) $level = 'A1';
    elseif ($percentage < 40) $level = 'A2';
    elseif ($percentage < 60) $level = 'B1';
    elseif ($percentage < 80) $level = 'B2';
    elseif ($percentage < 95) $level = 'C1';
    else $level = 'C2';
    
    // Update user level in session
    $_SESSION['user_level'] = $level;
    $_SESSION['test_completed'] = true;
    $_SESSION['test_score'] = $score;
    $_SESSION['total_questions'] = $total_questions;
    
    header('Location: /test-results');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>English Placement Test - Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .test-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 0;
        }
        .test-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
            overflow: hidden;
        }
        .test-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .test-body {
            padding: 40px;
        }
        .progress-container {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 30px;
        }
        .progress-bar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
            transition: width 0.5s ease;
        }
        .question-card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin-bottom: 25px;
            overflow: hidden;
        }
        .question-header {
            background: #f8f9ff;
            padding: 20px;
            border-bottom: 2px solid #e9ecef;
        }
        .question-body {
            padding: 25px;
        }
        .option-label {
            display: block;
            padding: 15px 20px;
            margin: 8px 0;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s;
        }
        .option-label:hover {
            border-color: #667eea;
            background: #f8f9ff;
        }
        .option-input:checked + .option-label {
            border-color: #667eea;
            background: #f8f9ff;
            font-weight: 600;
        }
        .option-input {
            display: none;
        }
        .timer-container {
            background: white;
            border-radius: 15px;
            padding: 15px 20px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            text-align: center;
        }
        .timer {
            font-size: 2rem;
            font-weight: bold;
            color: #667eea;
        }
        .nav-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .nav-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        .nav-btn:disabled {
            background: #6c757d;
            transform: none;
            box-shadow: none;
        }
        .question-counter {
            background: #667eea;
            color: white;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-right: 15px;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand fw-bold text-primary" href="/">
                <i class="fas fa-graduation-cap me-2"></i>Simturax
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="/dashboard">Dashboard</a>
            </div>
        </div>
    </nav>

    <!-- Test Section -->
    <section class="test-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="test-container">
                        <!-- Test Header -->
                        <div class="test-header">
                            <h2 class="fw-bold mb-3">English Placement Test</h2>
                            <p class="mb-0">Discover your exact English level and get personalized course recommendations</p>
                        </div>
                        
                        <!-- Test Body -->
                        <div class="test-body">
                            <!-- Progress Section -->
                            <div class="progress-container">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="question-counter" id="currentQuestion">1</div>
                                            <div>
                                                <h5 class="fw-bold mb-1" id="questionTitle">Question 1 of <?php echo count($questions); ?></h5>
                                                <p class="text-muted mb-0" id="questionType">Multiple Choice</p>
                                            </div>
                                        </div>
                                        <div class="progress" style="height: 8px;">
                                            <div class="progress-bar" id="testProgress" style="width: 20%"></div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="timer-container">
                                            <div class="text-muted small">TIME REMAINING</div>
                                            <div class="timer" id="testTimer">15:00</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Test Form -->
                            <form method="POST" action="" id="placementTestForm">
                                <input type="hidden" name="answers" id="userAnswers" value="{}">
                                
                                <!-- Questions will be dynamically loaded here -->
                                <div id="questionsContainer">
                                    <?php foreach ($questions as $index => $question): ?>
                                    <div class="question-card <?php echo $index === 0 ? 'active' : 'd-none'; ?>" data-question-id="<?php echo $question['id']; ?>">
                                        <div class="question-header">
                                            <h5 class="fw-bold mb-0"><?php echo $question['question']; ?></h5>
                                        </div>
                                        <div class="question-body">
                                            <?php foreach ($question['options'] as $key => $option): ?>
                                            <div class="mb-3">
                                                <input type="radio" class="option-input" id="q<?php echo $question['id']; ?>_<?php echo $key; ?>" 
                                                       name="question_<?php echo $question['id']; ?>" value="<?php echo $key; ?>">
                                                <label class="option-label" for="q<?php echo $question['id']; ?>_<?php echo $key; ?>">
                                                    <span class="fw-bold me-2"><?php echo $key; ?>.</span>
                                                    <?php echo $option; ?>
                                                </label>
                                            </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                                
                                <!-- Navigation Buttons -->
                                <div class="d-flex justify-content-between mt-4">
                                    <button type="button" class="btn btn-outline-secondary nav-btn" id="prevBtn" disabled>
                                        <i class="fas fa-arrow-left me-2"></i>Previous
                                    </button>
                                    <button type="button" class="btn btn-primary nav-btn" id="nextBtn">
                                        Next Question<i class="fas fa-arrow-right ms-2"></i>
                                    </button>
                                    <button type="submit" class="btn btn-success nav-btn d-none" id="submitBtn">
                                        <i class="fas fa-paper-plane me-2"></i>Submit Test
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Instructions Modal -->
    <div class="modal fade" id="instructionsModal" tabindex="-1" data-bs-backdrop="static">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Test Instructions</h5>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="text-center p-3">
                                <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                     style="width: 80px; height: 80px;">
                                    <i class="fas fa-clock text-white fa-2x"></i>
                                </div>
                                <h6>Time Limit</h6>
                                <p class="text-muted small">15 minutes for <?php echo count($questions); ?> questions</p>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="text-center p-3">
                                <div class="bg-success rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                     style="width: 80px; height: 80px;">
                                    <i class="fas fa-check-circle text-white fa-2x"></i>
                                </div>
                                <h6>No Negative Marking</h6>
                                <p class="text-muted small">Answer all questions - no penalty for wrong answers</p>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="text-center p-3">
                                <div class="bg-warning rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                     style="width: 80px; height: 80px;">
                                    <i class="fas fa-ban text-white fa-2x"></i>
                                </div>
                                <h6>No Going Back</h6>
                                <p class="text-muted small">You cannot return to previous questions</p>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="text-center p-3">
                                <div class="bg-info rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                     style="width: 80px; height: 80px;">
                                    <i class="fas fa-chart-line text-white fa-2x"></i>
                                </div>
                                <h6>Personalized Results</h6>
                                <p class="text-muted small">Get custom course recommendations</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="alert alert-info">
                        <h6><i class="fas fa-lightbulb me-2"></i>Tips for Success:</h6>
                        <ul class="mb-0">
                            <li>Read each question carefully before answering</li>
                            <li>Don't spend too much time on any single question</li>
                            <li>Choose the answer that seems most correct to you</li>
                            <li>The test adapts to your level as you progress</li>
                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary w-100" data-bs-dismiss="modal">
                        Start Test <i class="fas fa-play-circle ms-2"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        class PlacementTest {
            constructor() {
                this.currentQuestion = 1;
                this.totalQuestions = <?php echo count($questions); ?>;
                this.userAnswers = {};
                this.timeLeft = 15 * 60; // 15 minutes in seconds
                this.timerInterval = null;
                
                this.init();
            }
            
            init() {
                this.showInstructions();
                this.setupEventListeners();
                this.loadQuestion(1);
                this.startTimer();
            }
            
            showInstructions() {
                const modal = new bootstrap.Modal(document.getElementById('instructionsModal'));
                modal.show();
            }
            
            setupEventListeners() {
                // Next button
                document.getElementById('nextBtn').addEventListener('click', () => {
                    this.nextQuestion();
                });
                
                // Previous button
                document.getElementById('prevBtn').addEventListener('click', () => {
                    this.previousQuestion();
                });
                
                // Option selection
                document.querySelectorAll('.option-input').forEach(input => {
                    input.addEventListener('change', (e) => {
                        const questionId = e.target.name.replace('question_', '');
                        this.userAnswers[questionId] = e.target.value;
                        this.updateProgress();
                    });
                });
            }
            
            loadQuestion(questionNumber) {
                // Hide all questions
                document.querySelectorAll('.question-card').forEach(card => {
                    card.classList.add('d-none');
                    card.classList.remove('active');
                });
                
                // Show current question
                const currentCard = document.querySelector(`[data-question-id="${questionNumber}"]`);
                if (currentCard) {
                    currentCard.classList.remove('d-none');
                    currentCard.classList.add('active');
                }
                
                // Update UI
                document.getElementById('currentQuestion').textContent = questionNumber;
                document.getElementById('questionTitle').textContent = `Question ${questionNumber} of ${this.totalQuestions}`;
                
                // Update progress bar
                const progress = (questionNumber / this.totalQuestions) * 100;
                document.getElementById('testProgress').style.width = `${progress}%`;
                
                // Update navigation buttons
                this.updateNavigationButtons();
                
                // Restore selected answer if exists
                this.restoreAnswer(questionNumber);
            }
            
            nextQuestion() {
                if (this.currentQuestion < this.totalQuestions) {
                    this.currentQuestion++;
                    this.loadQuestion(this.currentQuestion);
                } else {
                    this.showSubmitButton();
                }
            }
            
            previousQuestion() {
                if (this.currentQuestion > 1) {
                    this.currentQuestion--;
                    this.loadQuestion(this.currentQuestion);
                }
            }
            
            updateNavigationButtons() {
                const prevBtn = document.getElementById('prevBtn');
                const nextBtn = document.getElementById('nextBtn');
                
                prevBtn.disabled = this.currentQuestion === 1;
                
                if (this.currentQuestion === this.totalQuestions) {
                    nextBtn.classList.add('d-none');
                    this.showSubmitButton();
                } else {
                    nextBtn.classList.remove('d-none');
                    document.getElementById('submitBtn').classList.add('d-none');
                }
            }
            
            showSubmitButton() {
                document.getElementById('nextBtn').classList.add('d-none');
                document.getElementById('submitBtn').classList.remove('d-none');
            }
            
            restoreAnswer(questionId) {
                const savedAnswer = this.userAnswers[questionId];
                if (savedAnswer) {
                    const input = document.querySelector(`input[name="question_${questionId}"][value="${savedAnswer}"]`);
                    if (input) {
                        input.checked = true;
                    }
                }
            }
            
            updateProgress() {
                // Update the hidden field with current answers
                document.getElementById('userAnswers').value = JSON.stringify(this.userAnswers);
                
                // You could add visual progress indicators here
                const answeredCount = Object.keys(this.userAnswers).length;
                console.log(`Answered: ${answeredCount}/${this.totalQuestions}`);
            }
            
            startTimer() {
                this.timerInterval = setInterval(() => {
                    this.timeLeft--;
                    this.updateTimerDisplay();
                    
                    if (this.timeLeft <= 0) {
                        this.submitTest();
                    }
                }, 1000);
            }
            
            updateTimerDisplay() {
                const minutes = Math.floor(this.timeLeft / 60);
                const seconds = this.timeLeft % 60;
                document.getElementById('testTimer').textContent = 
                    `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
                
                // Change color when time is running out
                if (this.timeLeft < 300) { // 5 minutes
                    document.getElementById('testTimer').style.color = '#dc3545';
                }
            }
            
            submitTest() {
                clearInterval(this.timerInterval);
                document.getElementById('placementTestForm').submit();
            }
        }
        
        // Initialize the test when page loads
        document.addEventListener('DOMContentLoaded', () => {
            new PlacementTest();
        });
        
        // Prevent form submission on enter key
        document.getElementById('placementTestForm').addEventListener('keypress', (e) => {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });
    </script>
</body>
</html>