<?php
// Display ads - no form processing here
if (!isset($db) || !$db) {
    echo '<div class="alert alert-danger">Database connection not available</div>';
    return;
}

try {
    // Fetch ads (read-only operations)
    $query = "SELECT * FROM ads ORDER BY position, created_at DESC";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $ads = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get ad for editing (read-only)
    $edit_ad = null;
    if ($_GET['edit'] ?? '') {
        $query = "SELECT * FROM ads WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$_GET['edit']]);
        $edit_ad = $stmt->fetch(PDO::FETCH_ASSOC);
    }
} catch (Exception $e) {
    echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    $ads = [];
}

// Ad types
$adTypes = [
    'banner' => 'Banner Ad',
    'sidebar' => 'Sidebar Ad', 
    'popup' => 'Popup Ad',
    'inline' => 'Inline Content Ad',
    'video' => 'Video Ad'
];

// Ad positions
$adPositions = [
    'header' => 'Header',
    'sidebar' => 'Sidebar',
    'footer' => 'Footer',
    'content_top' => 'Content Top',
    'content_bottom' => 'Content Bottom',
    'popup' => 'Popup'
];
?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Ads Manager</h2>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#adModal">
                <i class="fas fa-plus me-2"></i>Create New Ad
            </button>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Advertising Campaigns</h5>
    </div>
    <div class="card-body">
        <?php if (empty($ads)): ?>
        <div class="text-center py-4">
            <i class="fas fa-ad fa-3x text-muted mb-3"></i>
            <p class="text-muted">No ads found. Create your first ad campaign!</p>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#adModal">
                Create First Ad
            </button>
        </div>
        <?php else: ?>
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Type</th>
                        <th>Position</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($ads as $ad): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($ad['id']); ?></td>
                        <td>
                            <strong><?php echo htmlspecialchars($ad['title']); ?></strong>
                        </td>
                        <td>
                            <span class="badge bg-info"><?php echo $adTypes[$ad['ad_type']] ?? $ad['ad_type']; ?></span>
                        </td>
                        <td>
                            <span class="badge bg-secondary"><?php echo $adPositions[$ad['position']] ?? $ad['position']; ?></span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo $ad['status'] == 'active' ? 'success' : 'secondary'; ?>">
                                <?php echo ucfirst($ad['status']); ?>
                            </span>
                        </td>
                        <td><?php echo date('M j, Y', strtotime($ad['created_at'])); ?></td>
                        <td>
                            <a href="?action=ads&toggle=<?php echo $ad['id']; ?>" 
                               class="btn btn-sm btn-<?php echo $ad['status'] == 'active' ? 'warning' : 'success'; ?>"
                               title="<?php echo $ad['status'] == 'active' ? 'Deactivate' : 'Activate'; ?>">
                                <i class="fas fa-<?php echo $ad['status'] == 'active' ? 'pause' : 'play'; ?>"></i>
                            </a>
                            <a href="?action=ads&edit=<?php echo $ad['id']; ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="?action=ads&delete=<?php echo $ad['id']; ?>" class="btn btn-sm btn-outline-danger" 
                               onclick="return confirm('Are you sure you want to delete this ad?')">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Add/Edit Ad Modal -->
<div class="modal fade" id="adModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $edit_ad ? 'Edit Ad' : 'Create New Ad'; ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="?action=ads">
                <div class="modal-body">
                    <input type="hidden" name="action" value="<?php echo $edit_ad ? 'update_ad' : 'create_ad'; ?>">
                    <?php if ($edit_ad): ?>
                    <input type="hidden" name="id" value="<?php echo htmlspecialchars($edit_ad['id']); ?>">
                    <?php endif; ?>
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Ad Title *</label>
                        <input type="text" class="form-control" id="title" name="title" 
                               value="<?php echo htmlspecialchars($edit_ad['title'] ?? ''); ?>" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="ad_type" class="form-label">Ad Type *</label>
                                <select class="form-select" id="ad_type" name="ad_type" required>
                                    <?php foreach ($adTypes as $key => $name): ?>
                                    <option value="<?php echo $key; ?>" 
                                        <?php echo ($edit_ad['ad_type'] ?? '') == $key ? 'selected' : ''; ?>>
                                        <?php echo $name; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="position" class="form-label">Position *</label>
                                <select class="form-select" id="position" name="position" required>
                                    <?php foreach ($adPositions as $key => $name): ?>
                                    <option value="<?php echo $key; ?>" 
                                        <?php echo ($edit_ad['position'] ?? '') == $key ? 'selected' : ''; ?>>
                                        <?php echo $name; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="ad_code" class="form-label">Ad Code *</label>
                        <textarea class="form-control" id="ad_code" name="ad_code" rows="8" 
                                  placeholder="Paste your ad code (HTML, JavaScript, or iframe) here..." 
                                  required><?php echo htmlspecialchars($edit_ad['ad_code'] ?? ''); ?></textarea>
                        <div class="form-text">
                            For banner ads: Recommended size 728x90. For sidebar: 300x250.
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="status" class="form-label">Status *</label>
                        <select class="form-select" id="status" name="status" required>
                            <option value="active" <?php echo ($edit_ad['status'] ?? '') == 'active' ? 'selected' : ''; ?>>Active</option>
                            <option value="inactive" <?php echo ($edit_ad['status'] ?? '') == 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary"><?php echo $edit_ad ? 'Update Ad' : 'Create Ad'; ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php if ($_GET['edit'] ?? ''): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var adModal = new bootstrap.Modal(document.getElementById('adModal'));
    adModal.show();
});
</script>
<?php endif; ?>