<?php
// Dashboard - display only, no processing
if (!isset($db) || !$db) {
    $user_count = 0;
    $post_count = 0;
    $course_count = 0;
} else {
    try {
        // Get user count
        $stmt = $db->query("SELECT COUNT(*) as count FROM users");
        $user_count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
        
        // Get post count
        $stmt = $db->query("SELECT COUNT(*) as count FROM posts");
        $post_count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
        
        // Get course count
        $stmt = $db->query("SELECT COUNT(*) as count FROM courses");
        $course_count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
        
    } catch (Exception $e) {
        $user_count = $post_count = $course_count = 0;
    }
}
?>
<div class="row">
    <div class="col-12">
        <h2 class="mb-4">Dashboard</h2>
    </div>
</div>

<!-- Stats Cards -->
<div class="row">
    <div class="col-md-3 mb-4">
        <div class="card stat-card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex">
                    <div>
                        <h4 class="card-title"><?php echo $user_count; ?></h4>
                        <p class="card-text">Total Users</p>
                    </div>
                    <div class="ms-auto">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card stat-card text-white bg-success">
            <div class="card-body">
                <div class="d-flex">
                    <div>
                        <h4 class="card-title"><?php echo $post_count; ?></h4>
                        <p class="card-text">Blog Posts</p>
                    </div>
                    <div class="ms-auto">
                        <i class="fas fa-file-alt fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card stat-card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex">
                    <div>
                        <h4 class="card-title"><?php echo $course_count; ?></h4>
                        <p class="card-text">Courses</p>
                    </div>
                    <div class="ms-auto">
                        <i class="fas fa-book fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card stat-card text-white bg-info">
            <div class="card-body">
                <div class="d-flex">
                    <div>
                        <h4 class="card-title">6</h4>
                        <p class="card-text">English Levels</p>
                    </div>
                    <div class="ms-auto">
                        <i class="fas fa-chart-line fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <a href="?action=posts" class="btn btn-outline-primary w-100 d-flex align-items-center">
                            <i class="fas fa-file-alt me-2"></i>
                            Manage Posts
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="?action=courses" class="btn btn-outline-success w-100 d-flex align-items-center">
                            <i class="fas fa-book me-2"></i>
                            Manage Courses
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="?action=users" class="btn btn-outline-info w-100 d-flex align-items-center">
                            <i class="fas fa-users me-2"></i>
                            Manage Users
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="?action=media" class="btn btn-outline-warning w-100 d-flex align-items-center">
                            <i class="fas fa-images me-2"></i>
                            Media Library
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Recent Activity</h5>
            </div>
            <div class="card-body">
                <div class="list-group list-group-flush">
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <i class="fas fa-user-plus text-success me-2"></i>
                            <small>New user registration</small>
                        </div>
                        <small class="text-muted">2 hours ago</small>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <i class="fas fa-file-edit text-primary me-2"></i>
                            <small>Post updated</small>
                        </div>
                        <small class="text-muted">5 hours ago</small>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <i class="fas fa-level-up-alt text-info me-2"></i>
                            <small>User advanced to B2 level</small>
                        </div>
                        <small class="text-muted">1 day ago</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- System Status -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">System Status</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 text-center">
                        <div class="<?php echo $db ? 'text-success' : 'text-danger'; ?>">
                            <i class="fas fa-database fa-2x mb-2"></i>
                            <p class="mb-0">Database</p>
                            <small><?php echo $db ? 'Connected' : 'Disconnected'; ?></small>
                        </div>
                    </div>
                    <div class="col-md-3 text-center">
                        <div class="text-success">
                            <i class="fas fa-server fa-2x mb-2"></i>
                            <p class="mb-0">Web Server</p>
                            <small>Online</small>
                        </div>
                    </div>
                    <div class="col-md-3 text-center">
                        <div class="text-success">
                            <i class="fas fa-shield-alt fa-2x mb-2"></i>
                            <p class="mb-0">Security</p>
                            <small>Protected</small>
                        </div>
                    </div>
                    <div class="col-md-3 text-center">
                        <div class="text-success">
                            <i class="fas fa-sync fa-2x mb-2"></i>
                            <p class="mb-0">Updates</p>
                            <small>Current</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>