<?php
// Display media - no form processing here
if (!isset($db) || !$db) {
    echo '<div class="alert alert-danger">Database connection not available</div>';
    return;
}

try {
    // Fetch media files (read-only operations)
    $query = "SELECT * FROM media ORDER BY created_at DESC";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $media_files = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    $media_files = [];
}

// Format file size
function formatFileSize($bytes) {
    if ($bytes >= 1073741824) {
        return number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        return number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        return number_format($bytes / 1024, 2) . ' KB';
    } else {
        return $bytes . ' bytes';
    }
}
?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Media Manager</h2>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#uploadModal">
                <i class="fas fa-upload me-2"></i>Upload Files
            </button>
        </div>
    </div>
</div>

<!-- Upload Modal -->
<div class="modal fade" id="uploadModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Upload Media Files</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="?action=media" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" name="action" value="upload_media">
                    
                    <div class="mb-3">
                        <label for="media_files" class="form-label">Select Files</label>
                        <input type="file" class="form-control" id="media_files" name="media_files[]" multiple 
                               accept="image/*,video/*,audio/*,.pdf,.doc,.docx,.txt">
                        <div class="form-text">
                            Maximum file size: 10MB. Allowed types: images, videos, audio, PDF, Word, text files.
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Upload Files</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Media Library</h5>
    </div>
    <div class="card-body">
        <?php if (empty($media_files)): ?>
        <div class="text-center text-muted py-5">
            <i class="fas fa-images fa-3x mb-3"></i>
            <p>No media files found. Upload your first file!</p>
        </div>
        <?php else: ?>
        <div class="row">
            <?php foreach ($media_files as $file): ?>
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <?php if (strpos($file['mime_type'], 'image/') === 0): ?>
                    <img src="<?php echo str_replace('../../', '/', $file['file_path']); ?>" 
                         class="card-img-top" alt="<?php echo htmlspecialchars($file['original_name']); ?>"
                         style="height: 150px; object-fit: cover;">
                    <?php else: ?>
                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                         style="height: 150px;">
                        <i class="fas fa-file fa-3x text-secondary"></i>
                    </div>
                    <?php endif; ?>
                    
                    <div class="card-body d-flex flex-column">
                        <h6 class="card-title text-truncate" title="<?php echo htmlspecialchars($file['original_name']); ?>">
                            <?php echo htmlspecialchars($file['original_name']); ?>
                        </h6>
                        <div class="mt-auto">
                            <p class="card-text small text-muted mb-1">
                                Size: <?php echo formatFileSize($file['file_size']); ?>
                            </p>
                            <p class="card-text small text-muted mb-2">
                                Type: <?php echo $file['mime_type']; ?>
                            </p>
                            <div class="btn-group w-100">
                                <button type="button" class="btn btn-sm btn-outline-primary copy-url" 
                                        data-url="<?php echo str_replace('../../', '/', $file['file_path']); ?>">
                                    <i class="fas fa-copy"></i>
                                </button>
                                <a href="?action=media&delete=<?php echo $file['id']; ?>" 
                                   class="btn btn-sm btn-outline-danger"
                                   onclick="return confirm('Are you sure you want to delete this file?')">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Copy URL to clipboard
    const copyButtons = document.querySelectorAll('.copy-url');
    copyButtons.forEach(button => {
        button.addEventListener('click', function() {
            const url = this.getAttribute('data-url');
            navigator.clipboard.writeText(url).then(() => {
                const originalHTML = this.innerHTML;
                this.innerHTML = '<i class="fas fa-check"></i>';
                this.classList.remove('btn-outline-primary');
                this.classList.add('btn-success');
                
                setTimeout(() => {
                    this.innerHTML = originalHTML;
                    this.classList.remove('btn-success');
                    this.classList.add('btn-outline-primary');
                }, 2000);
            });
        });
    });
});
</script>