<?php
// Display notifications manager - no form processing here
if (!isset($db) || !$db) {
    echo '<div class="alert alert-danger">Database connection not available</div>';
    return;
}

// Notification types
$notificationTypes = [
    'info' => 'Information',
    'success' => 'Success', 
    'warning' => 'Warning',
    'error' => 'Error',
    'promotion' => 'Promotion'
];

// Audience types
$audienceTypes = [
    'all' => 'All Users',
    'students' => 'Students Only',
    'teachers' => 'Teachers Only',
    'inactive' => 'Inactive Users',
    'premium' => 'Premium Users'
];

// Sample notifications data
$notifications = [
    [
        'id' => '1',
        'title' => 'New Course Available',
        'message' => 'We have added new advanced grammar courses. Check them out!',
        'type' => 'info',
        'audience' => 'all',
        'status' => 'sent',
        'created_at' => '2024-01-15 09:00:00',
        'sent_at' => '2024-01-15 09:05:00'
    ],
    [
        'id' => '2',
        'title' => 'Maintenance Notice',
        'message' => 'The platform will be down for maintenance on Saturday 2-4 AM.',
        'type' => 'warning',
        'audience' => 'all',
        'status' => 'pending',
        'created_at' => '2024-01-16 14:30:00',
        'sent_at' => null
    ],
    [
        'id' => '3',
        'title' => 'Special Discount',
        'message' => 'Get 20% off on annual subscription. Limited time offer!',
        'type' => 'promotion',
        'audience' => 'students',
        'status' => 'sent',
        'created_at' => '2024-01-10 11:00:00',
        'sent_at' => '2024-01-10 11:00:00'
    ]
];
?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Notifications Manager</h2>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#notificationModal">
                <i class="fas fa-plus me-2"></i>Create Notification
            </button>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <!-- Notifications List -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Notifications</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th>Type</th>
                                <th>Audience</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($notifications as $notification): ?>
                            <tr>
                                <td>
                                    <strong><?php echo htmlspecialchars($notification['title']); ?></strong>
                                    <br>
                                    <small class="text-muted"><?php echo htmlspecialchars($notification['message']); ?></small>
                                </td>
                                <td>
                                    <span class="badge bg-<?php 
                                        switch($notification['type']) {
                                            case 'info': echo 'info'; break;
                                            case 'success': echo 'success'; break;
                                            case 'warning': echo 'warning'; break;
                                            case 'error': echo 'danger'; break;
                                            case 'promotion': echo 'primary'; break;
                                            default: echo 'secondary';
                                        }
                                    ?>">
                                        <?php echo $notificationTypes[$notification['type']] ?? $notification['type']; ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-secondary">
                                        <?php echo $audienceTypes[$notification['audience']] ?? $notification['audience']; ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo $notification['status'] == 'sent' ? 'success' : 'warning'; ?>">
                                        <?php echo ucfirst($notification['status']); ?>
                                    </span>
                                    <?php if ($notification['sent_at']): ?>
                                    <br>
                                    <small class="text-muted"><?php echo date('M j, g:i A', strtotime($notification['sent_at'])); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('M j, Y', strtotime($notification['created_at'])); ?></td>
                                <td>
                                    <?php if ($notification['status'] == 'pending'): ?>
                                    <a href="?action=notifications&send=<?php echo $notification['id']; ?>" 
                                       class="btn btn-sm btn-success"
                                       onclick="return confirm('Send this notification now?')">
                                        <i class="fas fa-paper-plane"></i>
                                    </a>
                                    <?php endif; ?>
                                    <a href="?action=notifications&delete=<?php echo $notification['id']; ?>" 
                                       class="btn btn-sm btn-outline-danger"
                                       onclick="return confirm('Are you sure you want to delete this notification?')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <!-- Notification Stats -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6 mb-3">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-primary">24</h3>
                                <small>Sent This Month</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-success">89%</h3>
                                <small>Open Rate</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-info">3</h3>
                                <small>Pending</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-warning">156</h3>
                                <small>Total Sent</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Templates -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Quick Templates</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button class="btn btn-outline-primary btn-sm" data-template="welcome">
                        <i class="fas fa-bolt me-2"></i>Welcome Message
                    </button>
                    <button class="btn btn-outline-success btn-sm" data-template="course_update">
                        <i class="fas fa-book me-2"></i>Course Update
                    </button>
                    <button class="btn btn-outline-warning btn-sm" data-template="maintenance">
                        <i class="fas fa-tools me-2"></i>Maintenance Alert
                    </button>
                    <button class="btn btn-outline-info btn-sm" data-template="promotion">
                        <i class="fas fa-percentage me-2"></i>Promotional Offer
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Create Notification Modal -->
<div class="modal fade" id="notificationModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create New Notification</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="?action=notifications">
                <div class="modal-body">
                    <input type="hidden" name="action" value="create_notification">
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Title *</label>
                        <input type="text" class="form-control" id="title" name="title" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="message" class="form-label">Message *</label>
                        <textarea class="form-control" id="message" name="message" rows="4" required></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="type" class="form-label">Type *</label>
                                <select class="form-select" id="type" name="type" required>
                                    <?php foreach ($notificationTypes as $key => $name): ?>
                                    <option value="<?php echo $key; ?>"><?php echo $name; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="audience" class="form-label">Audience *</label>
                                <select class="form-select" id="audience" name="audience" required>
                                    <?php foreach ($audienceTypes as $key => $name): ?>
                                    <option value="<?php echo $key; ?>"><?php echo $name; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="schedule" class="form-label">Schedule *</label>
                                <select class="form-select" id="schedule" name="schedule" required>
                                    <option value="immediate">Send Immediately</option>
                                    <option value="scheduled">Schedule for Later</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3" id="scheduledDateContainer" style="display: none;">
                                <label for="scheduled_date" class="form-label">Scheduled Date</label>
                                <input type="datetime-local" class="form-control" id="scheduled_date" name="scheduled_date">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Create Notification</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Show/hide scheduled date based on schedule selection
    const scheduleSelect = document.getElementById('schedule');
    const scheduledDateContainer = document.getElementById('scheduledDateContainer');
    
    if (scheduleSelect && scheduledDateContainer) {
        scheduleSelect.addEventListener('change', function() {
            if (this.value === 'scheduled') {
                scheduledDateContainer.style.display = 'block';
            } else {
                scheduledDateContainer.style.display = 'none';
            }
        });
    }
    
    // Quick template buttons
    const templateButtons = document.querySelectorAll('[data-template]');
    templateButtons.forEach(button => {
        button.addEventListener('click', function() {
            const template = this.getAttribute('data-template');
            const titleInput = document.getElementById('title');
            const messageInput = document.getElementById('message');
            const typeSelect = document.getElementById('type');
            
            const templates = {
                'welcome': {
                    title: 'Welcome to Simturax!',
                    message: 'We\'re excited to have you on board. Start your English learning journey today!',
                    type: 'info'
                },
                'course_update': {
                    title: 'New Course Available',
                    message: 'Check out our latest course addition and enhance your English skills!',
                    type: 'info'
                },
                'maintenance': {
                    title: 'Scheduled Maintenance',
                    message: 'The platform will be temporarily unavailable for maintenance. We apologize for any inconvenience.',
                    type: 'warning'
                },
                'promotion': {
                    title: 'Special Offer Inside!',
                    message: 'Limited time discount available. Upgrade your plan to unlock premium features!',
                    type: 'promotion'
                }
            };
            
            if (templates[template] && titleInput && messageInput && typeSelect) {
                titleInput.value = templates[template].title;
                messageInput.value = templates[template].message;
                typeSelect.value = templates[template].type;
                
                // Show the modal
                const modal = new bootstrap.Modal(document.getElementById('notificationModal'));
                modal.show();
            }
        });
    });
});
</script>