<?php
// Handle ads operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=ads&error=Database not available');
    exit;
}

try {
    // Handle create/update
    if ($_POST['action'] === 'create_ad') {
        $title = $_POST['title'] ?? '';
        $ad_type = $_POST['ad_type'] ?? 'banner';
        $ad_code = $_POST['ad_code'] ?? '';
        $position = $_POST['position'] ?? 'header';
        $status = $_POST['status'] ?? 'active';
        
        if (!empty($title) && !empty($ad_code)) {
            $query = "INSERT INTO ads (title, ad_type, ad_code, position, status, created_at) 
                      VALUES (?, ?, ?, ?, ?, NOW())";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $ad_type, $ad_code, $position, $status]);
            
            header('Location: ?action=ads&success=1');
            exit;
        }
    }
    
    if ($_POST['action'] === 'update_ad') {
        $id = $_POST['id'] ?? '';
        $title = $_POST['title'] ?? '';
        $ad_type = $_POST['ad_type'] ?? 'banner';
        $ad_code = $_POST['ad_code'] ?? '';
        $position = $_POST['position'] ?? 'header';
        $status = $_POST['status'] ?? 'active';
        
        if (!empty($id) && !empty($title) && !empty($ad_code)) {
            $query = "UPDATE ads SET title = ?, ad_type = ?, ad_code = ?, position = ?, 
                      status = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $ad_type, $ad_code, $position, $status, $id]);
            
            header('Location: ?action=ads&success=1');
            exit;
        }
    }

    // Handle delete
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        $query = "DELETE FROM ads WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=ads&success=1');
        exit;
    }

    // Handle toggle status
    if ($_GET['toggle'] ?? '') {
        $id = $_GET['toggle'];
        
        // Get current status
        $query = "SELECT status FROM ads WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        $ad = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($ad) {
            $new_status = $ad['status'] == 'active' ? 'inactive' : 'active';
            $query = "UPDATE ads SET status = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$new_status, $id]);
            
            header('Location: ?action=ads&success=1');
            exit;
        }
    }
} catch (Exception $e) {
    header('Location: ?action=ads&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=ads&error=Invalid operation');
exit;
?>