<?php
// Handle media operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=media&error=Database not available');
    exit;
}

try {
    // Handle file upload
    if ($_POST['action'] === 'upload_media') {
        if (isset($_FILES['media_files']) && !empty($_FILES['media_files']['name'][0])) {
            $uploadDir = '../../assets/uploads/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }
            
            $uploadedFiles = [];
            
            foreach ($_FILES['media_files']['name'] as $key => $name) {
                if ($_FILES['media_files']['error'][$key] === UPLOAD_ERR_OK) {
                    $tempName = $_FILES['media_files']['tmp_name'][$key];
                    $fileSize = $_FILES['media_files']['size'][$key];
                    $fileType = $_FILES['media_files']['type'][$key];
                    
                    // Generate unique filename
                    $fileExt = strtolower(pathinfo($name, PATHINFO_EXTENSION));
                    $fileName = uniqid() . '_' . preg_replace('/[^a-zA-Z0-9-_\.]/', '', $name);
                    $filePath = $uploadDir . $fileName;
                    
                    if (move_uploaded_file($tempName, $filePath)) {
                        // Insert into database
                        $query = "INSERT INTO media (filename, original_name, file_path, file_size, mime_type, uploaded_by, created_at) 
                                  VALUES (?, ?, ?, ?, ?, ?, NOW())";
                        $stmt = $db->prepare($query);
                        $stmt->execute([$fileName, $name, $filePath, $fileSize, $fileType, $_SESSION['admin_username'] ?? 'admin']);
                        
                        $uploadedFiles[] = $name;
                    }
                }
            }
            
            if (!empty($uploadedFiles)) {
                header('Location: ?action=media&success=' . urlencode('Files uploaded: ' . implode(', ', $uploadedFiles)));
            } else {
                header('Location: ?action=media&error=No files were uploaded');
            }
            exit;
        }
    }

    // Handle file deletion
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        
        // Get file info
        $query = "SELECT * FROM media WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        $file = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($file) {
            // Delete physical file
            if (file_exists($file['file_path'])) {
                unlink($file['file_path']);
            }
            
            // Delete from database
            $query = "DELETE FROM media WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$id]);
            
            header('Location: ?action=media&success=File deleted successfully');
            exit;
        }
    }
} catch (Exception $e) {
    header('Location: ?action=media&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=media&error=Invalid operation');
exit;
?>