<?php
// Handle notifications operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=notifications&error=Database not available');
    exit;
}

try {
    // Handle create notification
    if ($_POST['action'] === 'create_notification') {
        $title = $_POST['title'] ?? '';
        $message = $_POST['message'] ?? '';
        $type = $_POST['type'] ?? 'info';
        $audience = $_POST['audience'] ?? 'all';
        $schedule = $_POST['schedule'] ?? 'immediate';
        $scheduled_date = $_POST['scheduled_date'] ?? null;
        
        if (!empty($title) && !empty($message)) {
            $query = "INSERT INTO notifications (title, message, type, audience, schedule, 
                      scheduled_date, status, created_at) VALUES (?, ?, ?, ?, ?, ?, 'pending', NOW())";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $message, $type, $audience, $schedule, $scheduled_date]);
            
            header('Location: ?action=notifications&success=1');
            exit;
        }
    }
    
    // Handle send now
    if ($_GET['send'] ?? '') {
        $id = $_GET['send'];
        $query = "UPDATE notifications SET status = 'sent', sent_at = NOW() WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=notifications&success=1');
        exit;
    }

    // Handle delete notification
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        $query = "DELETE FROM notifications WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=notifications&success=1');
        exit;
    }
} catch (Exception $e) {
    header('Location: ?action=notifications&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=notifications&error=Invalid operation');
exit;
?>