<?php
// Handle page operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=pages&error=Database not available');
    exit;
}

try {
    // Handle create/update
    if ($_POST['action'] === 'create_page') {
        $title = $_POST['title'] ?? '';
        $slug = $_POST['slug'] ?? '';
        $content = $_POST['content'] ?? '';
        $status = $_POST['status'] ?? 'draft';
        $meta_title = $_POST['meta_title'] ?? '';
        $meta_description = $_POST['meta_description'] ?? '';
        
        if (!empty($title) && !empty($content) && !empty($slug)) {
            $query = "INSERT INTO pages (title, slug, content, status, meta_title, meta_description, created_at) 
                      VALUES (?, ?, ?, ?, ?, ?, NOW())";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $slug, $content, $status, $meta_title, $meta_description]);
            
            header('Location: ?action=pages&success=1');
            exit;
        }
    }
    
    if ($_POST['action'] === 'update_page') {
        $id = $_POST['id'] ?? '';
        $title = $_POST['title'] ?? '';
        $slug = $_POST['slug'] ?? '';
        $content = $_POST['content'] ?? '';
        $status = $_POST['status'] ?? 'draft';
        $meta_title = $_POST['meta_title'] ?? '';
        $meta_description = $_POST['meta_description'] ?? '';
        
        if (!empty($id) && !empty($title) && !empty($content) && !empty($slug)) {
            $query = "UPDATE pages SET title = ?, slug = ?, content = ?, status = ?, 
                      meta_title = ?, meta_description = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$title, $slug, $content, $status, $meta_title, $meta_description, $id]);
            
            header('Location: ?action=pages&success=1');
            exit;
        }
    }

    // Handle delete
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        $query = "DELETE FROM pages WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=pages&success=1');
        exit;
    }
} catch (Exception $e) {
    header('Location: ?action=pages&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=pages&error=Invalid operation');
exit;
?>