<?php
// Handle tags operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=tags&error=Database not available');
    exit;
}

try {
    // Handle create tag
    if ($_POST['action'] === 'create_tag') {
        $name = $_POST['name'] ?? '';
        $slug = $_POST['slug'] ?? '';
        $description = $_POST['description'] ?? '';
        
        if (!empty($name)) {
            $query = "INSERT INTO tags (name, slug, description, created_at) VALUES (?, ?, ?, NOW())";
            $stmt = $db->prepare($query);
            $stmt->execute([$name, $slug, $description]);
            
            header('Location: ?action=tags&success=1');
            exit;
        }
    }
    
    // Handle update tag
    if ($_POST['action'] === 'update_tag') {
        $id = $_POST['id'] ?? '';
        $name = $_POST['name'] ?? '';
        $slug = $_POST['slug'] ?? '';
        $description = $_POST['description'] ?? '';
        
        if (!empty($id) && !empty($name)) {
            $query = "UPDATE tags SET name = ?, slug = ?, description = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$name, $slug, $description, $id]);
            
            header('Location: ?action=tags&success=1');
            exit;
        }
    }

    // Handle delete tag
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        
        // Check if tag is in use
        $checkQuery = "SELECT COUNT(*) as count FROM post_tags WHERE tag_id = ?";
        $checkStmt = $db->prepare($checkQuery);
        $checkStmt->execute([$id]);
        $result = $checkStmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result['count'] > 0) {
            header('Location: ?action=tags&error=Tag is in use and cannot be deleted');
            exit;
        }
        
        $query = "DELETE FROM tags WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=tags&success=1');
        exit;
    }

    // Handle bulk actions
    if ($_POST['bulk_action'] ?? '') {
        $tag_ids = $_POST['tag_ids'] ?? [];
        $action = $_POST['bulk_action'];
        
        if (!empty($tag_ids)) {
            if ($action === 'delete') {
                $placeholders = str_repeat('?,', count($tag_ids) - 1) . '?';
                $query = "DELETE FROM tags WHERE id IN ($placeholders)";
                $stmt = $db->prepare($query);
                $stmt->execute($tag_ids);
                
                header('Location: ?action=tags&success=1');
                exit;
            }
        }
    }
} catch (Exception $e) {
    header('Location: ?action=tags&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=tags&error=Invalid operation');
exit;
?>