<?php
// Handle user operations - called before any HTML output
if (!isset($db) || !$db) {
    header('Location: ?action=users&error=Database not available');
    exit;
}

try {
    // Handle user status toggle
    if ($_GET['toggle'] ?? '') {
        $id = $_GET['toggle'];
        
        // Get current status
        $query = "SELECT status FROM users WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            $new_status = $user['status'] == 'active' ? 'suspended' : 'active';
            $query = "UPDATE users SET status = ?, updated_at = NOW() WHERE id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$new_status, $id]);
            
            header('Location: ?action=users&success=1');
            exit;
        }
    }

    // Handle delete
    if ($_GET['delete'] ?? '') {
        $id = $_GET['delete'];
        $query = "DELETE FROM users WHERE id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$id]);
        
        header('Location: ?action=users&success=1');
        exit;
    }
} catch (Exception $e) {
    header('Location: ?action=users&error=' . urlencode($e->getMessage()));
    exit;
}

// If we get here, something went wrong
header('Location: ?action=users&error=Invalid operation');
exit;
?>