<?php
// Display settings - no form processing here
if (!isset($db) || !$db) {
    echo '<div class="alert alert-danger">Database connection not available</div>';
    return;
}

try {
    // Fetch all settings
    $query = "SELECT * FROM settings";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $settings = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Convert to key-value pairs
    $settings_array = [];
    foreach ($settings as $setting) {
        $settings_array[$setting['setting_key']] = $setting['setting_value'];
    }

    // Default settings if not in database
    $default_settings = [
        'site_title' => 'Simturax English Learning',
        'site_description' => 'Learn English online with personalized courses',
        'admin_email' => 'admin@simturax.com',
        'items_per_page' => '10',
        'maintenance_mode' => '0',
        'registration_enabled' => '1',
        'smtp_host' => '',
        'smtp_port' => '587',
        'smtp_username' => '',
        'smtp_password' => '',
        'google_analytics' => '',
        'facebook_pixel' => '',
        'seo_meta_title' => 'Learn English Online - Simturax',
        'seo_meta_description' => 'Personalized English learning platform with placement tests and customized learning paths',
        'contact_email' => 'contact@simturax.com',
        'contact_phone' => '',
        'contact_address' => ''
    ];

    // Merge with existing settings
    $current_settings = array_merge($default_settings, $settings_array);
} catch (Exception $e) {
    echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    $current_settings = $default_settings;
}
?>
<div class="row">
    <div class="col-12">
        <h2 class="mb-4">Application Settings</h2>
    </div>
</div>

<form method="POST" action="?action=settings">
    <input type="hidden" name="action" value="update_settings">
    
    <div class="row">
        <div class="col-md-8">
            <!-- General Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">General Settings</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="site_title" class="form-label">Site Title</label>
                                <input type="text" class="form-control" id="site_title" name="settings[site_title]" 
                                       value="<?php echo htmlspecialchars($current_settings['site_title']); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="admin_email" class="form-label">Admin Email</label>
                                <input type="email" class="form-control" id="admin_email" name="settings[admin_email]" 
                                       value="<?php echo htmlspecialchars($current_settings['admin_email']); ?>" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="site_description" class="form-label">Site Description</label>
                        <textarea class="form-control" id="site_description" name="settings[site_description]" 
                                  rows="3"><?php echo htmlspecialchars($current_settings['site_description']); ?></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="items_per_page" class="form-label">Items Per Page</label>
                                <input type="number" class="form-control" id="items_per_page" name="settings[items_per_page]" 
                                       value="<?php echo htmlspecialchars($current_settings['items_per_page']); ?>" min="5" max="100">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Maintenance Mode</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="maintenance_mode" 
                                           name="settings[maintenance_mode]" value="1" 
                                           <?php echo $current_settings['maintenance_mode'] ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="maintenance_mode">Enable</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">User Registration</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="registration_enabled" 
                                           name="settings[registration_enabled]" value="1" 
                                           <?php echo $current_settings['registration_enabled'] ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="registration_enabled">Enable</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- SEO Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">SEO Settings</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="seo_meta_title" class="form-label">Default Meta Title</label>
                        <input type="text" class="form-control" id="seo_meta_title" name="settings[seo_meta_title]" 
                               value="<?php echo htmlspecialchars($current_settings['seo_meta_title']); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="seo_meta_description" class="form-label">Default Meta Description</label>
                        <textarea class="form-control" id="seo_meta_description" name="settings[seo_meta_description]" 
                                  rows="3"><?php echo htmlspecialchars($current_settings['seo_meta_description']); ?></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label for="google_analytics" class="form-label">Google Analytics ID</label>
                        <input type="text" class="form-control" id="google_analytics" name="settings[google_analytics]" 
                               value="<?php echo htmlspecialchars($current_settings['google_analytics']); ?>" 
                               placeholder="G-XXXXXXXXXX">
                    </div>
                    
                    <div class="mb-3">
                        <label for="facebook_pixel" class="form-label">Facebook Pixel ID</label>
                        <input type="text" class="form-control" id="facebook_pixel" name="settings[facebook_pixel]" 
                               value="<?php echo htmlspecialchars($current_settings['facebook_pixel']); ?>" 
                               placeholder="XXXXXXXXXXXXXXX">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Contact Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Contact Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="contact_email" class="form-label">Contact Email</label>
                        <input type="email" class="form-control" id="contact_email" name="settings[contact_email]" 
                               value="<?php echo htmlspecialchars($current_settings['contact_email']); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="contact_phone" class="form-label">Contact Phone</label>
                        <input type="text" class="form-control" id="contact_phone" name="settings[contact_phone]" 
                               value="<?php echo htmlspecialchars($current_settings['contact_phone']); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="contact_address" class="form-label">Contact Address</label>
                        <textarea class="form-control" id="contact_address" name="settings[contact_address]" 
                                  rows="3"><?php echo htmlspecialchars($current_settings['contact_address']); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Email Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Email Settings (SMTP)</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="smtp_host" class="form-label">SMTP Host</label>
                        <input type="text" class="form-control" id="smtp_host" name="settings[smtp_host]" 
                               value="<?php echo htmlspecialchars($current_settings['smtp_host']); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="smtp_port" class="form-label">SMTP Port</label>
                        <input type="number" class="form-control" id="smtp_port" name="settings[smtp_port]" 
                               value="<?php echo htmlspecialchars($current_settings['smtp_port']); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="smtp_username" class="form-label">SMTP Username</label>
                        <input type="text" class="form-control" id="smtp_username" name="settings[smtp_username]" 
                               value="<?php echo htmlspecialchars($current_settings['smtp_username']); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="smtp_password" class="form-label">SMTP Password</label>
                        <input type="password" class="form-control" id="smtp_password" name="settings[smtp_password]" 
                               value="<?php echo htmlspecialchars($current_settings['smtp_password']); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body text-center">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save me-2"></i>Save All Settings
            </button>
            <button type="reset" class="btn btn-outline-secondary btn-lg ms-2">Reset Changes</button>
        </div>
    </div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle checkbox values for form submission
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    checkboxes.forEach(checkbox => {
        // Set initial value
        checkbox.value = checkbox.checked ? '1' : '0';
        
        checkbox.addEventListener('change', function() {
            this.value = this.checked ? '1' : '0';
        });
    });
});
</script>