<?php
session_start();

// Define base path
define('BASE_PATH', __DIR__);

// Include database configuration
require_once BASE_PATH . '/app/config/database.php';

// Simple routing for public site
$request = $_SERVER['REQUEST_URI'];
$path = parse_url($request, PHP_URL_PATH);
$path = ltrim($path, '/');

// Route requests
switch($path) {
    case '':
    case 'home':
        include 'views/public/home.php';
        break;
    case 'login':
        include 'views/public/login.php';
        break;
    case 'signup':
    case 'register':
        include 'views/public/signup.php';
        break;
    case 'courses':
        include 'views/public/courses.php';
        break;
    case 'placement-test':
        include 'views/public/placement-test.php';
        break;
    case 'test-results':
        include 'views/public/test-results.php';
        break;
    case 'dashboard':
        include 'views/public/dashboard.php';
        break;
    case 'admin':
        header('Location: /admin/');
        exit;
    default:
        // Check if it's a learning route
        if (strpos($path, 'learning/') === 0) {
            include 'views/public/learning.php';
        } else {
            // 404 page
            include 'views/public/404.php';
        }
        break;
}
?>