<?php
// Simple database setup script
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html>
<html>
<head>
    <title>Database Setup</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css' rel='stylesheet'>
</head>
<body>
    <div class='container mt-5'>
        <h2>Database Setup</h2>
        <div class='card'>
            <div class='card-body'>";

try {
    // Test database connection
    $host = "localhost";
    $db_name = "techoisi_simturax";
    $username = "techoisi_simturax";
    $password = "0670445472@z";
    
    $pdo = new PDO("mysql:host=$host;dbname=$db_name", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<div class='alert alert-success'>✓ Database connection successful</div>";
    
    // Create users table
    $pdo->exec("CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        email VARCHAR(255) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        first_name VARCHAR(100),
        last_name VARCHAR(100),
        username VARCHAR(100) UNIQUE,
        profile_image VARCHAR(500),
        bio TEXT,
        current_level ENUM('A1', 'A2', 'B1', 'B2', 'C1', 'C2') DEFAULT 'A1',
        test_score INT,
        status ENUM('active', 'inactive', 'suspended') DEFAULT 'active',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");
    
    echo "<div class='alert alert-success'>✓ Users table created</div>";
    
    // Insert sample user
    $hashed_password = password_hash('student123', PASSWORD_DEFAULT);
    $pdo->exec("INSERT IGNORE INTO users (id, email, password, first_name, last_name, current_level) VALUES 
              (1, 'student@simturax.com', '$hashed_password', 'John', 'Student', 'B1')");
    
    echo "<div class='alert alert-success'>✓ Sample user created (student@simturax.com / student123)</div>";
    
    // Create other essential tables
    $tables = [
        "CREATE TABLE IF NOT EXISTS learning_content (
            id INT AUTO_INCREMENT PRIMARY KEY,
            title VARCHAR(255) NOT NULL,
            description TEXT,
            level ENUM('A1', 'A2', 'B1', 'B2', 'C1', 'C2') DEFAULT 'A1',
            skill_type ENUM('reading', 'writing', 'speaking', 'grammar', 'vocabulary') DEFAULT 'reading',
            is_active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )",
        
        "CREATE TABLE IF NOT EXISTS user_progress (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            content_id INT NOT NULL,
            completed BOOLEAN DEFAULT FALSE,
            score DECIMAL(5,2),
            time_spent INT DEFAULT 0,
            completed_at TIMESTAMP NULL,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )"
    ];
    
    foreach ($tables as $table) {
        $pdo->exec($table);
        echo "<div class='alert alert-success'>✓ Table created</div>";
    }
    
    // Insert sample learning content
    $pdo->exec("INSERT IGNORE INTO learning_content (title, description, level, skill_type) VALUES 
              ('Beginner Reading', 'Basic reading comprehension', 'A1', 'reading'),
              ('Grammar Basics', 'Introduction to English grammar', 'A1', 'grammar'),
              ('Vocabulary Builder', 'Essential English words', 'A1', 'vocabulary')");
    
    echo "<div class='alert alert-success'>✓ Sample learning content added</div>";
    
    echo "<div class='alert alert-success mt-3'><strong>Setup completed successfully!</strong></div>";
    echo "<p><strong>Test Account:</strong> student@simturax.com / student123</p>";
    echo "<a href='/dashboard' class='btn btn-primary'>Go to Dashboard</a>";
    
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Error: " . $e->getMessage() . "</div>";
    echo "<p>Please check your database credentials in app/config/database.php</p>";
}

echo "</div></div></div></body></html>";
?>