<?php
// Get level from query string for demo
$level = $_GET['level'] ?? 'A1';
$levelNames = [
    'A1' => 'Beginner',
    'A2' => 'Elementary',
    'B1' => 'Intermediate', 
    'B2' => 'Upper Intermediate',
    'C1' => 'Advanced',
    'C2' => 'Proficient'
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Dashboard - Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand fw-bold" href="/">Simturax English</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="/">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container-fluid mt-4">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3">
                <div class="list-group">
                    <a href="/dashboard" class="list-group-item list-group-item-action active">Dashboard</a>
                    <a href="/learning/reading" class="list-group-item list-group-item-action">Reading Skills</a>
                    <a href="/learning/speaking" class="list-group-item list-group-item-action">Speaking Skills</a>
                    <a href="/learning/writing" class="list-group-item list-group-item-action">Writing Skills</a>
                    <a href="/learning/grammar" class="list-group-item list-group-item-action">Grammar</a>
                    <a href="/learning/vocabulary" class="list-group-item list-group-item-action">Expand Vocabulary</a>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">My Learning Dashboard</h4>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-success">
                            <h5>Your Level: <?php echo $levelNames[$level]; ?> (<?php echo $level; ?>)</h5>
                            <p class="mb-0">Based on your placement test results, we've created a personalized learning path for you.</p>
                        </div>

                        <h5>Recommended Learning Path</h5>
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <h6>Grammar Foundations</h6>
                                        <div class="progress mb-2">
                                            <div class="progress-bar" style="width: 30%">30%</div>
                                        </div>
                                        <a href="/learning/grammar" class="btn btn-sm btn-primary">Continue</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <h6>Vocabulary Builder</h6>
                                        <div class="progress mb-2">
                                            <div class="progress-bar" style="width: 15%">15%</div>
                                        </div>
                                        <a href="/learning/vocabulary" class="btn btn-sm btn-primary">Start</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>