<?php
$skill = $_GET['skill'] ?? 'reading';
$skillNames = [
    'reading' => 'Reading Skills',
    'speaking' => 'Speaking Skills', 
    'writing' => 'Writing Skills',
    'grammar' => 'Grammar',
    'vocabulary' => 'Expand Vocabulary'
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $skillNames[$skill]; ?> - Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand fw-bold" href="/">Simturax English</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="/dashboard">Back to Dashboard</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0"><?php echo $skillNames[$skill]; ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <strong>Demo Content:</strong> The full <?php echo $skillNames[$skill]; ?> curriculum is under development.
                        </div>
                        
                        <h5>Coming Soon:</h5>
                        <ul>
                            <li>Interactive lessons</li>
                            <li>Practice exercises</li>
                            <li>Progress tracking</li>
                            <li>AI-powered feedback</li>
                        </ul>
                        
                        <a href="/dashboard" class="btn btn-primary">Back to Dashboard</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>