<?php
session_start();

// Redirect if test not completed
if (!isset($_SESSION['test_completed']) || !$_SESSION['test_completed']) {
    header('Location: /placement-test');
    exit;
}

$user_level = $_SESSION['user_level'] ?? 'B1';
$test_score = $_SESSION['test_score'] ?? 0;
$total_questions = $_SESSION['total_questions'] ?? 5;

// Level descriptions
$level_descriptions = [
    'A1' => [
        'title' => 'Beginner',
        'description' => 'You can understand and use familiar everyday expressions and very basic phrases aimed at the satisfaction of needs of a concrete type.',
        'color' => 'success',
        'next_steps' => ['Basic vocabulary building', 'Simple sentence structures', 'Everyday conversations']
    ],
    'A2' => [
        'title' => 'Elementary', 
        'description' => 'You can understand sentences and frequently used expressions related to areas of most immediate relevance.',
        'color' => 'info',
        'next_steps' => ['Expanding vocabulary', 'Basic grammar rules', 'Simple reading comprehension']
    ],
    'B1' => [
        'title' => 'Intermediate',
        'description' => 'You can understand the main points of clear standard input on familiar matters regularly encountered in work, school, leisure, etc.',
        'color' => 'primary',
        'next_steps' => ['Intermediate grammar', 'Conversation practice', 'Reading longer texts']
    ],
    'B2' => [
        'title' => 'Upper Intermediate',
        'description' => 'You can understand the main ideas of complex text on both concrete and abstract topics, including technical discussions in your field of specialization.',
        'color' => 'warning',
        'next_steps' => ['Advanced vocabulary', 'Complex sentence structures', 'Professional communication']
    ],
    'C1' => [
        'title' => 'Advanced',
        'description' => 'You can understand a wide range of demanding, longer texts, and recognize implicit meaning. You can express yourself fluently and spontaneously.',
        'color' => 'danger',
        'next_steps' => ['Academic writing', 'Advanced speaking skills', 'Nuanced comprehension']
    ],
    'C2' => [
        'title' => 'Proficient',
        'description' => 'You can understand with ease virtually everything heard or read. You can summarize information from different spoken and written sources.',
        'color' => 'dark',
        'next_steps' => ['Mastery of idioms', 'Professional fluency', 'Cultural nuances']
    ]
];

// Recommended courses based on level
$recommended_courses = [
    'A1' => ['Beginner English Foundation', 'Basic Vocabulary Builder', 'Simple Conversation Practice'],
    'A2' => ['Elementary Communication', 'Grammar Fundamentals', 'Everyday English'],
    'B1' => ['Intermediate Communication', 'Business English Basics', 'Reading Comprehension'],
    'B2' => ['Advanced Grammar', 'Professional Communication', 'Academic Writing'],
    'C1' => ['Business English Mastery', 'Advanced Conversation', 'Academic English'],
    'C2' => ['English Fluency', 'Professional Writing', 'Cultural English']
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Results - Simturax</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .results-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 0;
        }
        .results-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
            overflow: hidden;
        }
        .results-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px;
            text-align: center;
        }
        .results-body {
            padding: 40px;
        }
        .level-badge {
            font-size: 1.2rem;
            padding: 10px 25px;
            border-radius: 25px;
            font-weight: 600;
        }
        .score-circle {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            background: conic-gradient(#28a745 0% <?php echo ($test_score/$total_questions)*100; ?>%, #e9ecef <?php echo ($test_score/$total_questions)*100; ?>% 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
            position: relative;
        }
        .score-inner {
            width: 90px;
            height: 90px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 1.5rem;
        }
        .course-card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: all 0.3s;
            margin-bottom: 20px;
        }
        .course-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.15);
        }
        .progress-level {
            height: 8px;
            background: #e9ecef;
            border-radius: 4px;
            overflow: hidden;
            margin: 20px 0;
        }
        .progress-level-bar {
            height: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 4px;
        }
        .next-step-card {
            background: #f8f9ff;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 15px;
            border-left: 4px solid #667eea;
        }
        .celebration {
            animation: celebrate 2s ease-in-out;
        }
        @keyframes celebrate {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand fw-bold text-primary" href="/">
                <i class="fas fa-graduation-cap me-2"></i>Simturax
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="/dashboard">Dashboard</a>
                <a class="nav-link" href="/courses">Courses</a>
            </div>
        </div>
    </nav>

    <!-- Results Section -->
    <section class="results-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="results-card">
                        <!-- Header -->
                        <div class="results-header">
                            <div class="celebration">
                                <i class="fas fa-trophy fa-3x mb-3"></i>
                                <h2 class="fw-bold mb-2">Test Completed!</h2>
                                <p class="mb-0">Your English level has been determined</p>
                            </div>
                        </div>
                        
                        <!-- Results Body -->
                        <div class="results-body">
                            <!-- Score and Level -->
                            <div class="row align-items-center mb-5">
                                <div class="col-md-6 text-center">
                                    <div class="score-circle mb-3">
                                        <div class="score-inner">
                                            <?php echo $test_score; ?>/<?php echo $total_questions; ?>
                                        </div>
                                    </div>
                                    <h5 class="fw-bold">Your Score</h5>
                                    <p class="text-muted"><?php echo round(($test_score/$total_questions)*100); ?>% Correct</p>
                                </div>
                                <div class="col-md-6 text-center">
                                    <span class="level-badge bg-<?php echo $level_descriptions[$user_level]['color']; ?>">
                                        <?php echo $user_level; ?> - <?php echo $level_descriptions[$user_level]['title']; ?>
                                    </span>
                                    <h5 class="fw-bold mt-3">Your Level</h5>
                                    <p class="text-muted">Based on your test performance</p>
                                </div>
                            </div>
                            
                            <!-- Level Description -->
                            <div class="card mb-4">
                                <div class="card-body">
                                    <h5 class="fw-bold mb-3">About Your <?php echo $user_level; ?> Level</h5>
                                    <p class="mb-3"><?php echo $level_descriptions[$user_level]['description']; ?></p>
                                    
                                    <h6 class="fw-semibold mb-3">What you can typically do at this level:</h6>
                                    <div class="row">
                                        <?php foreach ($level_descriptions[$user_level]['next_steps'] as $step): ?>
                                        <div class="col-md-4 mb-2">
                                            <div class="next-step-card">
                                                <i class="fas fa-check text-success me-2"></i>
                                                <?php echo $step; ?>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Progress Path -->
                            <div class="card mb-4">
                                <div class="card-body">
                                    <h5 class="fw-bold mb-4">Your English Learning Path</h5>
                                    
                                    <div class="progress-level">
                                        <div class="progress-level-bar" style="width: <?php 
                                            $level_positions = ['A1' => 0, 'A2' => 20, 'B1' => 40, 'B2' => 60, 'C1' => 80, 'C2' => 100];
                                            echo $level_positions[$user_level];
                                        ?>%"></div>
                                    </div>
                                    
                                    <div class="row text-center">
                                        <div class="col">
                                            <div class="<?php echo $user_level === 'A1' ? 'fw-bold text-primary' : 'text-muted'; ?>">A1</div>
                                            <small>Beginner</small>
                                        </div>
                                        <div class="col">
                                            <div class="<?php echo $user_level === 'A2' ? 'fw-bold text-primary' : 'text-muted'; ?>">A2</div>
                                            <small>Elementary</small>
                                        </div>
                                        <div class="col">
                                            <div class="<?php echo $user_level === 'B1' ? 'fw-bold text-primary' : 'text-muted'; ?>">B1</div>
                                            <small>Intermediate</small>
                                        </div>
                                        <div class="col">
                                            <div class="<?php echo $user_level === 'B2' ? 'fw-bold text-primary' : 'text-muted'; ?>">B2</div>
                                            <small>Upper Intermediate</small>
                                        </div>
                                        <div class="col">
                                            <div class="<?php echo $user_level === 'C1' ? 'fw-bold text-primary' : 'text-muted'; ?>">C1</div>
                                            <small>Advanced</small>
                                        </div>
                                        <div class="col">
                                            <div class="<?php echo $user_level === 'C2' ? 'fw-bold text-primary' : 'text-muted'; ?>">C2</div>
                                            <small>Proficient</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Recommended Courses -->
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="fw-bold mb-4">Recommended Courses for You</h5>
                                    <div class="row">
                                        <?php foreach ($recommended_courses[$user_level] as $course): ?>
                                        <div class="col-md-4">
                                            <div class="course-card">
                                                <div class="card-body text-center">
                                                    <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                                         style="width: 60px; height: 60px;">
                                                        <i class="fas fa-book text-white"></i>
                                                    </div>
                                                    <h6 class="fw-bold"><?php echo $course; ?></h6>
                                                    <p class="text-muted small mb-3">Perfect for your current level</p>
                                                    <a href="/courses" class="btn btn-outline-primary btn-sm">
                                                        View Course
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Action Buttons -->
                            <div class="text-center mt-5">
                                <div class="row justify-content-center">
                                    <div class="col-md-4 mb-3">
                                        <a href="/courses" class="btn btn-primary btn-lg w-100">
                                            <i class="fas fa-play-circle me-2"></i>Start Learning
                                        </a>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <a href="/dashboard" class="btn btn-outline-primary btn-lg w-100">
                                            <i class="fas fa-tachometer-alt me-2"></i>Go to Dashboard
                                        </a>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <a href="/placement-test" class="btn btn-outline-secondary btn-lg w-100">
                                            <i class="fas fa-redo me-2"></i>Retake Test
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Add confetti effect for celebration
        document.addEventListener('DOMContentLoaded', function() {
            // Simple celebration effect
            const celebration = document.querySelector('.celebration');
            if (celebration) {
                setTimeout(() => {
                    celebration.style.animation = 'none';
                    setTimeout(() => {
                        celebration.style.animation = 'celebrate 2s ease-in-out';
                    }, 100);
                }, 2000);
            }
            
            // Smooth scroll to results
            setTimeout(() => {
                document.querySelector('.results-card').scrollIntoView({ 
                    behavior: 'smooth',
                    block: 'center'
                });
            }, 500);
        });
    </script>
</body>
</html>